/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.backlog.IBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IDependencyConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.WorkItemPersistency;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BacklogPersistency {
    private final WorkItemPersistency persistency;
    private final PortfolioWorkItemPersistence workItemPersistence;

    BacklogPersistency(WorkItemPersistency persistency, PortfolioWorkItemPersistence workItemPersistence) {
        this.persistency = persistency;
        this.workItemPersistence = workItemPersistence;
    }

    public BacklogPersistency(ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence) {
        this(new WorkItemPersistency(activeObjectsUtilities, workItemPersistence), workItemPersistence);
    }

    public void persistBacklog(IBacklogConfiguration configuration, IPlan plan) throws Exception {
        HashMap itemIdToTitleMap = Maps.newHashMap();
        List epicConfigurations = Lists.reverse(configuration.getEpicConfigurations());
        for (IEpicConfiguration epicConfiguration : epicConfigurations) {
            Map<String, String> epicIdTitleMap = this.persistency.persistEpic(epicConfiguration, plan);
            itemIdToTitleMap.putAll(epicIdTitleMap);
        }
        IDependencyConfiguration dependencyConfiguration = configuration.getDependencyConfiguration();
        if (dependencyConfiguration == null) {
            return;
        }
        this.persisteDependencies(dependencyConfiguration, itemIdToTitleMap);
    }

    private void persisteDependencies(IDependencyConfiguration dependencyConfiguration, Map<String, String> itemIdToTitleMap) throws SQLException {
        PortfolioWorkItemPersistence persistencyLayer = this.workItemPersistence;
        Map<String, String> nonNullTitleToIdMap = this.createTitleToIdMap(itemIdToTitleMap);
        Map<String, Set<String>> titleToPrerequisiteTitles = dependencyConfiguration.getTitleToPrerequisiteTitles();
        for (Map.Entry<String, Set<String>> prerequisiteTitleEntry : titleToPrerequisiteTitles.entrySet()) {
            String dependentId = nonNullTitleToIdMap.get(prerequisiteTitleEntry.getKey());
            Set<String> prerequisiteIds = this.getRequirementsId(prerequisiteTitleEntry.getValue(), nonNullTitleToIdMap);
            persistencyLayer.setDependencies(dependentId, Lists.newArrayList(prerequisiteIds));
        }
    }

    private Set<String> getRequirementsId(Set<String> titles, Map<String, String> nonNullTitleToIdMap) {
        HashSet ids = Sets.newHashSet();
        for (String title : titles) {
            String id = nonNullTitleToIdMap.get(title);
            ids.add(id);
        }
        return ids;
    }

    private Map<String, String> createTitleToIdMap(Map<String, String> itemIdToTitleMap) {
        HashMap titleToIdMap = Maps.newHashMap();
        for (Map.Entry<String, String> idToTitle : itemIdToTitleMap.entrySet()) {
            String title = idToTitle.getValue();
            if (title == null) continue;
            titleToIdMap.put(title, idToTitle.getKey());
        }
        return titleToIdMap;
    }
}

