/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.IResultAwareQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ITransactionalFuture;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ResultAwareQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.SQLTransaction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TransactionalSortingSQL
extends BaseTransactionalAOPersistenceSQL {
    private final ActiveObjectsUtilities activeObjectsUtilities;

    public TransactionalSortingSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    public SQLTransaction getMoveTransaction(Class<?> table, String orderRangeIdentifier, String id, MoveMode mode, String anchor) throws SQLException {
        SQLTransaction moveTransaction = SQLTransaction.create(this.activeObjectsUtilities);
        ITransactionalFuture<Map<String, Long>> edges = moveTransaction.add(TransactionalSortingSQL.getSortOrders(table, id, anchor));
        moveTransaction.add(TransactionalSortingSQL.modifySortOrderRange(orderRangeIdentifier, table, id, anchor, mode, edges));
        moveTransaction.add(TransactionalSortingSQL.setSortOrder(table, id, anchor, mode, edges, orderRangeIdentifier));
        return moveTransaction;
    }

    public void moveToPosition(Class<?> table, String orderRangeIdentifier, String id, MoveMode mode, String anchor) throws SQLException {
        SQLTransaction transaction = this.getMoveTransaction(table, orderRangeIdentifier, id, mode, anchor);
        transaction.execute();
    }

    private static Long getSortOrderOfItemThatWillBeMoved(String id, ITransactionalFuture<Map<String, Long>> edges) {
        return edges.get().get(id);
    }

    private static Long getSortOrderThatItemWillBeMovedTo(String anchor, MoveMode mode, ITransactionalFuture<Map<String, Long>> edges) {
        Long sortOrder = edges.get().get(anchor);
        if (sortOrder != null) {
            switch (mode) {
                case TOP: {
                    return -1L;
                }
                case AFTER: {
                    return sortOrder;
                }
                case BEFORE: {
                    return sortOrder - 1L;
                }
            }
        }
        return -1L;
    }

    private static IUpdate setSortOrder(final Class<?> table, final String id, final String anchor, final MoveMode mode, final ITransactionalFuture<Map<String, Long>> edges, final String orderRangeIdentifier) throws SQLException {
        return new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                Long sortOrderThatItemWillBeMovedTo;
                Long sortOrderOfItemThatWillBeMoved = TransactionalSortingSQL.getSortOrderOfItemThatWillBeMoved(id, edges);
                Long sortOrder = sortOrderThatItemWillBeMovedTo = TransactionalSortingSQL.getSortOrderThatItemWillBeMovedTo(anchor, mode, edges);
                if (sortOrderOfItemThatWillBeMoved > sortOrderThatItemWillBeMovedTo) {
                    Long l = sortOrder;
                    Long l2 = sortOrder = Long.valueOf(sortOrder + 1L);
                }
                generator.withTable(table, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().numeric(sortOrder).raw(", ").colNoAlias("t", "orderRangeId").eq().str(orderRangeIdentifier).where().colIdNoAlias("t").eq().numeric(id);
            }
        };
    }

    private static IUpdate modifySortOrderRange(final String orderRangeIdentifier, final Class<?> table, final String id, final String anchor, final MoveMode mode, final ITransactionalFuture<Map<String, Long>> edges) throws SQLException {
        return new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                String modifier;
                Long sortOrderOfItemThatWillBeMoved = TransactionalSortingSQL.getSortOrderOfItemThatWillBeMoved(id, edges);
                Long sortOrderThatItemWillBeMovedTo = TransactionalSortingSQL.getSortOrderThatItemWillBeMovedTo(anchor, mode, edges);
                Long lower = Math.min(sortOrderOfItemThatWillBeMoved, sortOrderThatItemWillBeMovedTo);
                Long upper = Math.max(sortOrderOfItemThatWillBeMoved, sortOrderThatItemWillBeMovedTo);
                String string = modifier = sortOrderOfItemThatWillBeMoved > sortOrderThatItemWillBeMovedTo ? " + 1" : " - 1";
                if (sortOrderOfItemThatWillBeMoved < sortOrderThatItemWillBeMovedTo) {
                    Long l = upper;
                    Long l2 = upper = Long.valueOf(upper + 1L);
                }
                generator.withTable(table, "t").update().tableNoAlias("t").set().colNoAlias("t", "sortOrder").eq().raw("(").colNoAlias("t", "sortOrder").raw(" " + modifier).raw(")").where().colNoAlias("t", "sortOrder").gt().numeric(lower).and().colNoAlias("t", "sortOrder").lt().numeric(upper).and().colNoAlias("t", "orderrange").eq().str(orderRangeIdentifier);
            }
        };
    }

    private static IResultAwareQuery<Map<String, Long>> getSortOrders(final Class<?> table, String ... ids) throws SQLException {
        final HashSet checkedIds = Sets.newHashSet();
        for (String id : ids) {
            if (id == null) continue;
            checkedIds.add(id);
        }
        return new ResultAwareQuery<Map<String, Long>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(table, "t").select().colId("t").col("t", "sortOrder").from("t").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("t");
                    }
                }, checkedIds);
            }

            @Override
            public Map<String, Long> handleAndStoreResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    retVal.put(result.getString(1), result.getLong(2));
                }
                return retVal;
            }
        };
    }
}

