/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.AOWorkItemToRes;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkItemToResourceSQL
extends BaseAOPersistenceSQL {
    private final PortfolioResourcePersistence resourcePersistence;

    public WorkItemToResourceSQL(ActiveObjectsUtilities activeObjectsUtilities, PortfolioResourcePersistence resourcePersistence) {
        super(activeObjectsUtilities);
        this.resourcePersistence = resourcePersistence;
    }

    public Set<String> getResourceAssignmentsForWorkItem(String workItemId, boolean replanning) throws SQLException {
        Map<String, Set<String>> items = this.getResourceAssignmentsForWorkItems(Sets.newHashSet((Object[])new String[]{workItemId}), replanning);
        return items.get(workItemId);
    }

    public Map<String, Set<String>> getResourceAssignmentsForWorkItems(final Set<String> workItemIds, final boolean replanning) throws SQLException {
        if (workItemIds.size() == 0) {
            return Maps.newHashMap();
        }
        return this.sql(new IQuery<Map<String, Set<String>>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItemToRes.class, "t").select().col("t", "aoWorkItem").col("t", "aoResource").from("t").where().col("t", "replanning").eq().bool(replanning).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("t", "aoWorkItem");
                    }
                }, workItemIds);
            }

            @Override
            public Map<String, Set<String>> handleResult(ResultSet result) throws Exception {
                HashMap retVal = Maps.newHashMap();
                while (result.next()) {
                    String workItem = BaseAOPersistenceSQL.getString(result, 1);
                    String resource = BaseAOPersistenceSQL.getString(result, 2);
                    if (!retVal.containsKey(workItem)) {
                        retVal.put(workItem, Sets.newHashSet((Object[])new String[]{resource}));
                        continue;
                    }
                    ((Set)retVal.get(workItem)).add(resource);
                }
                return retVal;
            }
        });
    }

    public void setResourceAssignment(String workItemId, List<String> resourceIds, boolean replanning) throws SQLException {
        for (String resource : resourceIds) {
            if (!this.resourcePersistence.exists(resource)) continue;
            this.insertAssignment(workItemId, resource, replanning);
        }
    }

    private void insertAssignment(final String workItemId, final String resourceId, final boolean replanning) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItemToRes.class, "t").insert().tableNoAlias("t").raw("(").colNoAlias("t", "aoWorkItem").colNoAlias("t", "aoResource").colNoAlias("t", "replanning").raw(") VALUES (").numeric(workItemId).raw(",").numeric(resourceId).raw(",").bool(replanning).raw(")");
            }
        });
    }

    public void clearResourceAssignmentsForResources(final String resourceId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItemToRes.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoResource").eq().numeric(resourceId);
            }
        });
    }

    public void clearResourceAssignmentsForWorkItems(final List<String> workItemIds, final Boolean replanning) throws SQLException {
        if (workItemIds == null || workItemIds.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItemToRes.class, "t").deleteFrom().tableNoAlias("t").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("t", "aoWorkItem");
                    }
                }, workItemIds);
                if (replanning != null) {
                    generator.and().colNoAlias("t", "replanning").eq().bool(replanning);
                }
            }
        });
    }

    public Boolean validateResourceAssignments(final String teamId, final List<String> resourceIds) throws SQLException {
        if (resourceIds == null || resourceIds.isEmpty()) {
            return true;
        }
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOResource.class, "r").select().raw("COUNT(*)").from("r").where().col("r", "aoTeam").neq().numeric(teamId).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("r");
                    }
                }, resourceIds);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next() && BaseAOPersistenceSQL.getInt(result, 1) == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public void replanResourceAssignments(final List<String> ids) throws SQLException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItemToRes.class, "t").update().tableNoAlias("t").set().colNoAlias("t", "replanning").eq().bool(false).where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("t", "aoWorkItem");
                    }
                }, ids);
            }
        });
    }
}

