/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.SprintSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.TeamSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemRelationSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsTeamPersistence
extends AOSortableEntityPersistence<ITeam, AOTeam>
implements PortfolioTeamPersistence {
    private final WorkItemRelationSQL workItemRelationSQL;
    private final TeamSQL teamSQL;
    private final PersonSQL personSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final StreamToTeamSql streamToTeamSql;
    private final SprintSQL sprintSql;
    private final PortfolioPlanPersistence planPersistence;

    @Autowired
    public PortfolioActiveObjectsTeamPersistence(PersistenceIndex persistenceIndex, ActiveObjectsUtilities utils, PortfolioPlanPersistence planPersistence, UserManagementExtension userManagementExtension) {
        super(utils, ITeam.class, AOTeam.class);
        this.planPersistence = planPersistence;
        this.workItemRelationSQL = new WorkItemRelationSQL(utils);
        this.teamSQL = new TeamSQL(utils);
        this.personSQL = new PersonSQL(utils, userManagementExtension);
        this.entityInfoSQL = new EntityInfoSQL(utils);
        this.sprintSql = new SprintSQL(utils);
        this.streamToTeamSql = new StreamToTeamSql(persistenceIndex, utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioTeamPersistence.class;
    }

    @Override
    protected void transform(ITeam source, AOTeam target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        if (source.getPlan() != null) {
            target.setPlan((IPlan)this.planPersistence.get(source.getPlan().getId()));
        }
        if (source.getPlanningMode() != null) {
            target.setPlanningMode(source.getPlanningMode());
        }
        if (source.getIterationStartType() != null) {
            target.setIterationStartType(source.getIterationStartType());
        }
        if (source.getVelocity() != null) {
            target.setVelocity(source.getVelocity());
        }
        if (source.getIncrementalAdjustment() != null) {
            target.setIncrementalAdjustment(source.getIncrementalAdjustment());
        }
        if (source.getAutoAdjustToAbsences() != null) {
            target.setAutoAdjustToAbsences(source.getAutoAdjustToAbsences());
        }
        if (source.getWeeksPerSprint() != null && source.getWeeksPerSprint() != -1) {
            target.setWeeksPerSprint(source.getWeeksPerSprint());
        }
    }

    @Override
    public EntityInfo getEntityInfo(String teamId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(teamId, AOTeam.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public List<ITeam> listCustom(String planId) throws SQLException {
        return this.teamSQL.getTeams(planId);
    }

    @Override
    public List<ITeam> listCustomWithPersons(String planId, boolean enrich) throws SQLException {
        Map<String, IPerson> persons = this.personSQL.getPersons(planId, enrich);
        return this.teamSQL.getTeams(planId, persons);
    }

    @Override
    public void updateVelocitySettings(String teamId, Double velocity, Double incrementalAdjustment, Boolean autoAdjustToAbsences) throws SQLException {
        this.teamSQL.updateVelocitySettings(teamId, velocity, incrementalAdjustment, autoAdjustToAbsences);
    }

    @Override
    public void setPlanningMode(String teamId, PlanningMode planningMode) throws SQLException {
        if (planningMode.equals((Object)PlanningMode.Kanban)) {
            this.workItemRelationSQL.clearSprintAssignments(this.sprintIdsForTeam(teamId));
        }
        this.teamSQL.setPlanningMode(teamId, planningMode);
    }

    private List<String> sprintIdsForTeam(String teamId) throws SQLException {
        List<ISprint> sprints = this.sprintSql.listForTeam(teamId);
        ArrayList<String> sprintIds = new ArrayList<String>();
        for (ISprint sprint : sprints) {
            sprintIds.add(sprint.getId());
        }
        return sprintIds;
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.workItemRelationSQL.deleteReplanningRelationsForTarget(id, "team");
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete replannings for team '" + id + "'", ex);
        }
        try {
            this.streamToTeamSql.clearStreamAssignmentsForTeam(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to delete stream assignments for team '" + id + "'", ex);
        }
        return super.delete(id, inCascade);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOTeam.class, "t").select().raw("*").from("t").where().col("t", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder");
        }
    }
}

