/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAvailability;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAvailability;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.AvailabilityIntervalSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsAvailabilityIntervalPersistence
extends AOSortableEntityPersistence<IAvailability, AOAvailability>
implements PortfolioAvailabilityIntervalPersistence {
    private final AvailabilityIntervalSQL availabilityIntervalSQL;
    private final EntityInfoSQL entityInfoSQL;

    @Autowired
    public PortfolioActiveObjectsAvailabilityIntervalPersistence(ActiveObjectsUtilities utils) {
        super(utils, IAvailability.class, AOAvailability.class);
        this.availabilityIntervalSQL = new AvailabilityIntervalSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioAvailabilityIntervalPersistence.class;
    }

    @Override
    protected void transform(IAvailability source, AOAvailability target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setAvailability(source.getAvailability());
        target.setStartDate(source.getStartDate());
        target.setEndDate(source.getEndDate());
        if (source.getResource() != null) {
            target.setResource(source.getResource());
        }
    }

    @Override
    public EntityInfo getEntityInfo(String intervalId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(intervalId, AOAvailability.class, new EntityInfoSQL.ParentRelationship(AOResource.class, "aoResource"), new EntityInfoSQL.ParentRelationship(AOPerson.class, "aoPerson"));
    }

    @Override
    public List<IAvailability> listForResource(String resourceId) throws SQLException {
        return Lists.newArrayList(this.availabilityIntervalSQL.listForResource(resourceId));
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOAvailability.class, "t").withTable(AOResource.class, "h1").withTable(AOPerson.class, "h2").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "aoResource").eq().colId("h1").leftJoin().table("h2").on().col("h1", "aoPerson").eq().colId("h2").where().col("h2", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder").colId("t");
        }
    }
}

