/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.people.BaseRestPersonInterval;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PersonIntervalSQL
extends BaseAOPersistenceSQL {
    public PersonIntervalSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public <TPersonInterval, TRestPersonInterval extends BaseRestPersonInterval> List<TRestPersonInterval> listForPerson(final Class<TPersonInterval> aoIntervalClass, final Class<TRestPersonInterval> restClazz, final String personId) throws SQLException {
        return (List)this.sql(new IQuery<List<TRestPersonInterval>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(aoIntervalClass, "i").select().colId("i").col("i", "title").col("i", "description").col("i", "version").col("i", "startDate").col("i", "endDate").col("i", "sortOrder").from("i").where().col("i", "aoPerson").eq().numeric(personId).orderBy().col("i", "sortOrder");
            }

            @Override
            public List<TRestPersonInterval> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    BaseRestPersonInterval interval = (BaseRestPersonInterval)restClazz.newInstance();
                    interval.setId(BaseAOPersistenceSQL.getString(result, 1));
                    interval.setTitle(BaseAOPersistenceSQL.getString(result, 2));
                    interval.setDescription(BaseAOPersistenceSQL.getString(result, 3));
                    interval.setVersion(PersonIntervalSQL.getLong(result, 4));
                    interval.setStartDate(PersonIntervalSQL.getLong(result, 5));
                    interval.setEndDate(PersonIntervalSQL.getLong(result, 6));
                    interval.setSortOrder(PersonIntervalSQL.getLong(result, 7));
                    retVal.add(interval);
                }
                return retVal;
            }
        });
    }
}

