/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.ReleaseQueryResult;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql.ReleaseSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemRelationSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemReplanningSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsReleasePersistence
extends AOSortableEntityPersistence<IRelease, AORelease>
implements PortfolioReleasePersistence {
    private final WorkItemRelationSQL workItemRelationSQL;
    private final ReleaseSQL releaseSQL;
    private final WorkItemReplanningSQL workItemReplanningSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final PortfolioStreamPersistence streamPersistence;

    @Autowired
    public PortfolioActiveObjectsReleasePersistence(ActiveObjectsUtilities utils, PortfolioStreamPersistence streamPersistence) {
        super(utils, IRelease.class, AORelease.class);
        this.streamPersistence = streamPersistence;
        this.workItemRelationSQL = new WorkItemRelationSQL(utils);
        this.releaseSQL = new ReleaseSQL(utils);
        this.workItemReplanningSQL = new WorkItemReplanningSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioReleasePersistence.class;
    }

    @Override
    protected void transform(IRelease source, AORelease target) throws Exception {
        this.transformRelease(source, target);
    }

    @Override
    public void transformRelease(IRelease source, AORelease target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setFixedStartDate((Long)source.getFixedStartDate().orNull());
        target.setFixedEndDate((Long)source.getFixedEndDate().orNull());
        target.setDeltaStartDate((Long)source.getDeltaStartDate().orNull());
        target.setPrimaryVersion(source.getPrimaryVersion());
        if (source.getStream() != null) {
            target.setStream((IStream)this.streamPersistence.get(source.getStream().getId()));
        } else {
            target.setStream(null);
        }
        target.setIsLaterRelease(source.getIsLaterRelease());
    }

    @Override
    public EntityInfo getEntityInfo(String releaseId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(releaseId, AORelease.class, new EntityInfoSQL.ParentRelationship(AOStream.class, "aoStream"));
    }

    @Override
    public List<IRelease> listCustom(String streamId, boolean includeLater) throws SQLException {
        return this.releaseSQL.getReleases(streamId, includeLater);
    }

    @Override
    public ReleaseQueryResult listCustomWithLinksAndStreamInfo(Collection<String> releaseIds) throws SQLException {
        return this.releaseSQL.getReleasesWithDetails(releaseIds);
    }

    @Override
    public IRelease getLaterReleaseCustom(String planId) throws SQLException {
        return this.releaseSQL.getLaterRelease(planId);
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.workItemRelationSQL.deleteReplanningRelationsForTarget(id, "release");
            this.workItemReplanningSQL.cascadeReplanningStreamOnReleaseDeletion(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete replannings for release '" + id + "'", ex);
        }
        return super.delete(id, inCascade);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AORelease.class, "t").withTable(AOStream.class, "h1").withTable(AOStream.class, "h2").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "aoStream").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().raw("(").select().col("h2", "sortOrder").from("h2").where().colId("h2").eq().col("t", "aoStream").raw("),").col("t", "sortOrder");
        }
    }
}

