/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.solutions.sql;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.solutions.AOSolutionStore;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.InsertAdapter;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.ICustomTransaction;
import com.radiantminds.roadmap.common.gson.RestSchedulingSolutionGson;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SolutionSQL
extends BaseTransactionalAOPersistenceSQL {
    private static final Log LOGGER = Log.with(SolutionSQL.class);

    public SolutionSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public void removeSolutionsForPlan(final String planId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").deleteFrom().tableNoAlias("s").where().colNoAlias("s", "aoPlan").eq().numeric(planId);
            }
        });
    }

    public void removeSolutionsForPlan(final String planId, Connection connection) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").deleteFrom().tableNoAlias("s").where().colNoAlias("s", "aoPlan").eq().numeric(planId);
            }
        }, connection, false);
    }

    public Optional<RestSchedulingSolution> getSolution(final @Nonnull String planId, final @Nullable Long schedulingVersion) throws SQLException {
        return this.sql(new IQuery<Optional<RestSchedulingSolution>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").select().col("s", "solution").from("s").where().col("s", "aoPlan").eq().numeric(planId);
                if (schedulingVersion != null) {
                    generator.and().col("s", "solutionVersion").gte().numeric(schedulingVersion);
                }
            }

            @Override
            public Optional<RestSchedulingSolution> handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    String json = BaseAOPersistenceSQL.getString(result, 1);
                    Gson gson = RestSchedulingSolutionGson.get();
                    return Optional.of((Object)gson.fromJson(json, RestSchedulingSolution.class));
                }
                return Optional.absent();
            }
        });
    }

    public void storeSolution(final String planId, final RestSchedulingSolution solution) throws SQLException {
        this.inCustomTransaction(new ICustomTransaction<Void>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Void execute(Connection connection) throws SQLException {
                boolean exists = SolutionSQL.this.exists(planId, connection);
                Gson gson = RestSchedulingSolutionGson.get();
                String json = gson.toJson(solution);
                if (!exists) {
                    try {
                        SolutionSQL.this.insert(planId, solution, json, connection);
                        if (SolutionSQL.this.planExists(planId, connection)) return null;
                        SolutionSQL.this.removeSolutionsForPlan(planId, connection);
                        return null;
                    }
                    catch (SQLException ex) {
                        LOGGER.info("Attempted concurrent solution insert. Rolling back connection, attempting update instead.", new Object[0]);
                        connection.rollback();
                        if (SolutionSQL.this.exists(planId, connection)) {
                            SolutionSQL.this.update(planId, solution, json, connection);
                            LOGGER.info("Update executed.", new Object[0]);
                            return null;
                        }
                        LOGGER.info("Update failed.", new Object[0]);
                        throw ex;
                    }
                } else {
                    SolutionSQL.this.update(planId, solution, json, connection);
                }
                return null;
            }
        });
    }

    private boolean planExists(final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                return result.next();
            }

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlan.class, "p").select().colId("p").from("p").where().colId("p").eq().numeric(planId);
            }
        }, connection, false);
    }

    private boolean exists(final String planId, Connection connection) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").select().colId("s").from("s").where().col("s", "aoPlan").eq().numeric(planId);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                return result.next();
            }
        }, connection, false);
    }

    private void update(final String planId, final RestSchedulingSolution solution, final String json, Connection connection) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").update().tableNoAlias("s").set().colNoAlias("s", "solutionVersion").eq().numeric(solution.getVersion()).raw(",").colNoAlias("s", "solution").eq().str(json).where().colNoAlias("s", "aoPlan").eq().numeric(planId).and().colNoAlias("s", "solutionVersion").lt().numeric(solution.getVersion());
            }
        }, connection, false);
    }

    private void insert(final String planId, final RestSchedulingSolution solution, final String json, Connection connection) throws SQLException {
        this.sql(new InsertAdapter(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSolutionStore.class, "s").insert().tableNoAlias("s").raw("(").colNoAlias("s", "aoPlan").colNoAlias("s", "solutionVersion").colNoAlias("s", "solution").raw(")").raw("VALUES").raw("(").numeric(planId).raw(",").numeric(solution.getVersion()).raw(",").str(json).raw(")");
            }
        }, connection, false);
    }
}

