/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import java.sql.SQLException;
import java.util.List;

public class EstimateTableHelper {
    static final List<String> COLUMNS = Lists.newArrayList((Object[])new String[]{"estimate", "original", "replanning", "targetId", "targetType"});
    private static final String TABLE_SKILL = "skill";

    public static int getColumnSelectCount() {
        return COLUMNS.size();
    }

    public static void addColumnsToSelect(String tableAlias, AOQueryGenerator generator) {
        for (String column : COLUMNS) {
            generator.col(tableAlias, column);
        }
    }

    public static void addEstimateJoin(final String tableAlias, List<String> workItemLevels, boolean includeReplanning, boolean filteringEnabled, IWorkItemFilter filter, AOQueryGenerator generator) throws SQLException {
        boolean stageFilteringEnabled = filteringEnabled && filter.getStageIds() != null && !filter.getStageIds().isEmpty();
        generator.leftJoin().raw("(").select();
        EstimateTableHelper.addColumnsToSelect(tableAlias, generator);
        generator.col(tableAlias, "aoWorkItem");
        if (stageFilteringEnabled) {
            generator.withTable(AOSkill.class, TABLE_SKILL);
            generator.col(TABLE_SKILL, "aoStage");
        }
        generator.from(tableAlias);
        if (stageFilteringEnabled) {
            generator.leftJoin().table(TABLE_SKILL).on().col(tableAlias, "targetType").eq().str(TABLE_SKILL).and().col(tableAlias, "targetId").eq().colId(TABLE_SKILL);
        }
        if (!includeReplanning) {
            generator.where().col(tableAlias, "replanning").neq().bool(true);
        }
        if (stageFilteringEnabled) {
            if (!includeReplanning) {
                generator.and();
            } else {
                generator.where();
            }
            generator.raw("(").col(tableAlias, "targetType").eq().str("total").or().inNumeric(new AOQueryGenerator.InOperandCallback(){

                @Override
                public void generateOperand(AOQueryGenerator generator) {
                    generator.colCoalesce(EstimateTableHelper.TABLE_SKILL, "aoStage", true, tableAlias, "targetId", true);
                }
            }, filter.getStageIds()).raw(")");
        }
        generator.raw(") " + tableAlias).on();
        generator.col(tableAlias, "aoWorkItem").eq().colId(workItemLevels.get(0));
        for (int i = 1; i < workItemLevels.size(); ++i) {
            generator.or().col(tableAlias, "aoWorkItem").eq().colId(workItemLevels.get(i));
        }
    }
}

