/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import java.util.List;

final class WorkItemTableHelper {
    static final List<String> COLUMNS = Lists.newArrayList((Object[])new String[]{"type", "title", "details", "sortOrder", "version", "status", "hasOriginalEstimates", "aoEarliestStart", "aoTargetStart", "aoTargetEnd", "aoBusinessValue", "aoTeam", "aoSprint", "aoRelease", "aoStream", "aoTheme"});
    static final List<String> REPLANNING_COLUMNS = Lists.newArrayList((Object[])new String[]{"replanningStatus"});

    WorkItemTableHelper() {
    }

    public static int getColumnSelectCount(boolean includeReplanning) {
        int size = COLUMNS.size() + 1;
        if (includeReplanning) {
            size += REPLANNING_COLUMNS.size();
        }
        return size;
    }

    public static void addJoin(String tableAlias, String withTableAlias, String planId, AOQueryGenerator generator) {
        generator.leftJoin().table(tableAlias).on().col(tableAlias, "aoParent").eq().colId(withTableAlias).and().col(tableAlias, "aoPlan").eq().numeric(planId);
    }

    public static void addColumnsToSelect(String tableAlias, boolean includeReplanning, AOQueryGenerator generator) {
        generator.colId(tableAlias);
        for (String column : COLUMNS) {
            generator.col(tableAlias, column);
        }
        if (includeReplanning) {
            for (String column : REPLANNING_COLUMNS) {
                generator.col(tableAlias, column);
            }
        }
    }
}

