/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOPerson;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.SQLException;

public class U_00200_DescriptionDetailsLengthUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 200;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        new UpgradeSQL(utils).moveDescriptionsToLongDescription(this, utils);
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private static class UpgradeSQL
    extends BaseAOPersistenceSQL {
        public UpgradeSQL(ActiveObjectsUtilities utils) {
            super(utils);
        }

        public void moveDescriptionsToLongDescription(BaseUpgradeTask task, ActiveObjectsUtilities utils) throws SQLException {
            this.moveDescriptionToLongDescription(AOWorkItem.class, task, utils);
            this.moveDescriptionToLongDescription(AOPlan.class, task, utils);
            this.moveDescriptionToLongDescription(AORelease.class, task, utils);
            this.moveDescriptionToLongDescription(AOStage.class, task, utils);
            this.moveDescriptionToLongDescription(AOSkill.class, task, utils);
            this.moveDescriptionToLongDescription(AOPerson.class, task, utils);
            this.moveDescriptionToLongDescription(AOTeam.class, task, utils);
        }

        public String getDescription() {
            return null;
        }

        private void moveDescriptionToLongDescription(final Class<?> describable, BaseUpgradeTask task, ActiveObjectsUtilities utils) throws SQLException {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(describable, "t").withTable(UpgradeSQL.class, "x").update().tableNoAlias("t").set().colNoAlias("t", "details").eq().colNoAlias("x", "description").where().colNoAlias("x", "description").isNotNull();
                }
            }, task.getOrCreateConnection(utils.getAccessor()));
        }
    }
}

