/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.AOPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.transactions.BaseTransactionalAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class U_01700_PlanLevelPermissionsUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1700;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL sql = new UpgradeSQL(this, utils);
        sql.perform();
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return false;
    }

    private static class PermissionEntry {
        private final String holderId;
        private final String holderType;
        private final String targetId;

        private PermissionEntry(String holderId, String holderType, String targetId) {
            this.holderId = holderId;
            this.holderType = holderType;
            this.targetId = targetId;
        }

        public String getHolderId() {
            return this.holderId;
        }

        public String getHolderType() {
            return this.holderType;
        }

        public String getTargetId() {
            return this.targetId;
        }
    }

    private static class UpgradeSQL
    extends BaseTransactionalAOPersistenceSQL {
        private final BaseUpgradeTask task;
        private final ActiveObjectsUtilities utils;

        public UpgradeSQL(BaseUpgradeTask task, ActiveObjectsUtilities utils) {
            super(utils);
            this.task = task;
            this.utils = utils;
        }

        private Connection getConnection() throws SQLException {
            return this.task.getOrCreateConnection(this.utils.getAccessor());
        }

        public void perform() throws Exception {
            ArrayList updates = Lists.newArrayList();
            for (final PermissionEntry entry : this.getPlanPermissions()) {
                updates.add(new IUpdate(){

                    @Override
                    public void sql(AOQueryGenerator generator) throws Exception {
                        generator.withTable(AOPermission.class, "p").insert().tableNoAlias("p").raw("(").colNoAlias("p", "holderId").colNoAlias("p", "holderType").colNoAlias("p", "targetId").colNoAlias("p", "targetType").colNoAlias("p", "permission").colNoAlias("p", "version").raw(") VALUES (").str(entry.getHolderId()).raw(",").str(entry.getHolderType()).raw(",").str(entry.getTargetId()).raw(",").str("plan").raw(",").numeric(IPermission.PERMISSION_VIEWER).raw(",").numeric(0).raw(")");
                    }
                });
            }
            this.handleUpdatesInTransaction(updates, this.getConnection());
        }

        private List<PermissionEntry> getPlanPermissions() throws SQLException {
            return this.sql(new IQuery<List<PermissionEntry>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPermission.class, "p").select().col("p", "holderId").col("p", "holderType").col("p", "targetId").from("p").where().col("p", "targetType").eq().str("plan");
                }

                @Override
                public List<PermissionEntry> handleResult(ResultSet result) throws Exception {
                    ArrayList retVal = Lists.newArrayList();
                    while (result.next()) {
                        retVal.add(new PermissionEntry(BaseAOPersistenceSQL.getString(result, 1), BaseAOPersistenceSQL.getString(result, 2), BaseAOPersistenceSQL.getString(result, 3)));
                    }
                    return retVal;
                }
            }, this.getConnection());
        }
    }
}

