/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface SyncOperationResult {
    public static final SyncOperationResult EMPTY = new Impl();

    public List<ViolationMessage> getGlobalViolations();

    public Map<String, List<ViolationMessage>> getItemViolations();

    public List<String> getProcessedItems();

    public static class Impl
    implements SyncOperationResult {
        private final List<ViolationMessage> globalViolations;
        private final Map<String, List<ViolationMessage>> itemViolations;
        private final List<String> processedItems;

        public Impl() {
            this.globalViolations = Lists.newArrayList();
            this.itemViolations = Maps.newHashMap();
            this.processedItems = Lists.newArrayList();
        }

        public Impl(List<ViolationMessage> globalViolations, Map<String, List<ViolationMessage>> itemViolations, List<String> processedItems) {
            this.globalViolations = globalViolations;
            this.itemViolations = itemViolations;
            this.processedItems = processedItems;
        }

        @Override
        public List<ViolationMessage> getGlobalViolations() {
            return this.globalViolations;
        }

        @Override
        public Map<String, List<ViolationMessage>> getItemViolations() {
            return this.itemViolations;
        }

        @Override
        public List<String> getProcessedItems() {
            return this.processedItems;
        }

        public void addGlobalViolations(Collection<ViolationMessage> violations) {
            this.globalViolations.addAll(violations);
        }

        public void addGlobalWarning(String message) {
            this.globalViolations.add(new ViolationMessage.Impl("warning", message));
        }

        public void addGlobalError(String message) {
            this.globalViolations.add(new ViolationMessage.Impl("error", message));
        }

        public void setItemViolations(String id, List<ViolationMessage> violations) {
            this.itemViolations.put(id, violations);
        }

        public void addProcessedItem(String id) {
            this.processedItems.add(id);
        }
    }
}

