/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.progress;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="progressconfig")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestProgressConfiguration
implements ProgressConfiguration {
    @XmlElement
    private String trackerType;
    @XmlElement
    private Boolean completeIfResolved;
    @XmlElement
    private String storyPointSubTaskMode;
    @XmlElement
    private String manualFieldName;

    @Deprecated
    private RestProgressConfiguration() {
    }

    public RestProgressConfiguration(String trackerType, Boolean completeIfResolved, String storyPointSubTaskMode, String manualFieldName) {
        this.trackerType = trackerType;
        this.completeIfResolved = completeIfResolved;
        this.storyPointSubTaskMode = storyPointSubTaskMode;
        this.manualFieldName = manualFieldName;
    }

    @Override
    public TrackerType getTrackerType() {
        if (this.trackerType == null) {
            return null;
        }
        return TrackerType.fromString(this.trackerType);
    }

    @Override
    public Boolean isCompleteIfResolved() {
        return this.completeIfResolved;
    }

    @Override
    public String getStoryPointSubTaskMode() {
        return this.storyPointSubTaskMode;
    }

    @Override
    public String getManualFieldName() {
        return this.manualFieldName;
    }

    public static RestProgressConfiguration from(IPlanConfiguration planConfiguration) {
        TrackerType trackerType = planConfiguration.getProgressTrackerType();
        return new RestProgressConfiguration(trackerType != null ? trackerType.toString() : null, planConfiguration.getProgCmpltIfRslvd(), planConfiguration.getProgStrySubTaskMode(), planConfiguration.getProgFieldName());
    }

    public static RestProgressConfiguration from(ProgressConfiguration progressConfiguration) {
        Preconditions.checkNotNull((Object)progressConfiguration);
        return new RestProgressConfiguration(progressConfiguration.getTrackerType().toString(), progressConfiguration.isCompleteIfResolved(), progressConfiguration.getStoryPointSubTaskMode(), progressConfiguration.getManualFieldName());
    }
}

