/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.permissions;

import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import com.radiantminds.roadmap.common.rest.services.permissions.PlanPermissionServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/permissions")
@Component
public class PlanPermissionService {
    private final PlanPermissionServiceHandler handler;
    private final PortfolioPermissionPersistence permissionPersistence;

    @Autowired
    public PlanPermissionService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, PortfolioPermissionPersistence permissionPersistence, PlanPermissions planPermissionHandler, PluginPermissions pluginPermissionHandler, UserExtension userExtension) {
        this.handler = handlerFactory.createProxy(PlanPermissionServiceHandler.class, new PlanPermissionServiceHandler.Impl(permissionPersistence, planPermissionHandler, pluginPermissionHandler, userExtension), planPersistence);
        this.permissionPersistence = permissionPersistence;
    }

    @POST
    public Response setPermission(RestPermission permission) throws Exception {
        return this.handler.setPermission(EntityContext.from(permission.getTargetId()), permission);
    }

    @DELETE
    @Path(value="{id}")
    public Response deletePermission(@PathParam(value="id") String permissionId) throws Exception {
        IPermission permission = (IPermission)this.permissionPersistence.get(permissionId);
        if (permission == null) {
            return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
        }
        if (!"plan".equals(permission.getTargetType())) {
            return ResponseBuilder.badRequest(RestMessaging.error("not a plan permission"));
        }
        return this.handler.deletePermission(EntityContext.from(permission.getTargetId()), permissionId);
    }

    @GET
    @Path(value="{targetId}")
    public Response getPermissions(@PathParam(value="targetId") String planId) throws Exception {
        return this.handler.getPermissions(EntityContext.from(planId));
    }
}

