/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.resources;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IAvailability;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.intervals.AOAvailability;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestAvailability;
import java.util.List;
import javax.ws.rs.core.Response;

public interface ResourceServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllAvailabilities(EntityContext<IResource> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rankAvailability(EntityContext<IResource> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addAvailabilityToResource(EntityContext<IResource> var1, RestAvailability var2) throws Exception;

    public static class Impl
    implements ResourceServiceHandler {
        private final PortfolioAvailabilityIntervalPersistence availabilityPersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioAvailabilityIntervalPersistence availabilityPersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.availabilityPersistence = availabilityPersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllAvailabilities(EntityContext<IResource> entityContext) throws Exception {
            List<IAvailability> intervals = this.availabilityPersistence.listForResource(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestAvailability.class, IAvailability.class, intervals), RestAvailability.class));
        }

        @Override
        public Response rankAvailability(EntityContext<IResource> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AOAvailability.class, this.availabilityPersistence, "resource", rank);
        }

        @Override
        public Response addAvailabilityToResource(EntityContext<IResource> entityContext, RestAvailability newAvailability) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOAvailability.class, "resource", newAvailability, new SubCollectionUtilsCallback.Adapter<IResource, IAvailability, RestAvailability>(){

                @Override
                public void setParent(IResource parent, IAvailability entity) {
                    entity.setResource(parent);
                }

                @Override
                public IAvailability persist(IAvailability entity) throws Exception {
                    return availabilityPersistence.persist(entity);
                }

                @Override
                public IAvailability get(String id) throws Exception {
                    return (IAvailability)availabilityPersistence.get(id);
                }
            });
        }
    }
}

