/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.skills;

import com.radiantminds.roadmap.common.data.entities.common.IPercentable;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import com.radiantminds.roadmap.common.rest.utils.PercentageUtils;
import javax.ws.rs.core.Response;

public interface SkillServiceHandler {
    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response setPercentage(EntityContext<ISkill> var1, Double var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response entryDelete(EntityContext<ISkill> var1) throws Exception;

    public static class Impl
    implements SkillServiceHandler {
        private final PortfolioSkillPersistence skillPersistence;
        private final PortfolioStagePersistence stagePersistence;

        public Impl(PortfolioSkillPersistence skillPersistence, PortfolioStagePersistence stagePersistence) {
            this.skillPersistence = skillPersistence;
            this.stagePersistence = stagePersistence;
        }

        @Override
        public Response setPercentage(EntityContext<ISkill> entityContext, Double value) throws Exception {
            ModificationResult retVal = PercentageUtils.setPercentage((IPercentable)entityContext.getEntity(), value, IPercentableCallback.SKILL, this.skillPersistence);
            return entityContext.ok(retVal);
        }

        @Override
        public Response entryDelete(EntityContext<ISkill> entityContext) throws Exception {
            IStage stage = entityContext.getEntity().getStage();
            this.skillPersistence.delete(entityContext.getEntityId(), false);
            if (stage != null) {
                PercentageUtils.adaptToItemRemoval(this.stagePersistence.get(stage.getId()), IPercentableCallback.SKILL, this.skillPersistence);
            }
            return entityContext.ok();
        }
    }
}

