/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.filters.FiltersExtension;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterDescription;
import com.radiantminds.roadmap.common.extensions.filters.IssueFilterSearchResult;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.extensions.projects.ProjectAccess;
import com.radiantminds.roadmap.common.extensions.projects.ProjectExtension;
import com.radiantminds.roadmap.common.extensions.projects.ProjectNotFoundException;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionDuplicateNameException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionPermissionException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionReleaseDateBeforeStartDateException;
import com.radiantminds.roadmap.common.extensions.versions.ListVersionResult;
import com.radiantminds.roadmap.common.extensions.versions.VersionExtension;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueLinksResult;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssuePermissionException;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueResult;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.extensions.workitems.search.IIssueSearchResult;
import com.radiantminds.roadmap.common.handlers.ContextAwareSecureService;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityParam;
import com.radiantminds.roadmap.common.handlers.ParameterType;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanFullUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.system.RestCreateIssueRequest;
import com.radiantminds.roadmap.common.rest.entities.system.RestCreateIssueResult;
import com.radiantminds.roadmap.common.rest.entities.system.RestGroupAndUserListConfiguration;
import com.radiantminds.roadmap.common.rest.entities.system.RestGroupAndUserListResult;
import com.radiantminds.roadmap.common.rest.entities.system.RestIssueFilterDescription;
import com.radiantminds.roadmap.common.rest.entities.system.RestIssueFilterSearchResult;
import com.radiantminds.roadmap.common.rest.services.system.IssueRequest;
import com.radiantminds.roadmap.common.rest.services.system.entities.RestImportRequest;
import com.radiantminds.roadmap.common.rest.services.system.entities.RestImportResult;
import com.radiantminds.roadmap.common.rest.services.system.entities.RestImportResultEntry;
import com.radiantminds.roadmap.common.rest.services.system.issuelinks.DefaultCreateIssueLinksForDependenciesRequest;
import com.radiantminds.roadmap.common.rest.services.system.issuelinks.RestCreateIssueLinksForDependenciesRequest;
import com.radiantminds.roadmap.common.rest.services.system.issuelinks.RestCreateIssueLinksForDependenciesResult;
import com.radiantminds.roadmap.common.rest.services.system.projects.RestProjectListRequest;
import com.radiantminds.roadmap.common.rest.services.system.projects.RestProjectSearchResult;
import com.radiantminds.roadmap.common.rest.services.system.versions.RestCreateVersionRequest;
import com.radiantminds.roadmap.common.rest.services.system.versions.RestCreateVersionResult;
import com.radiantminds.roadmap.common.rest.services.system.versions.RestListVersionResponse;
import com.radiantminds.roadmap.common.rest.services.system.versions.RestVersionListRequest;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/system")
@ContextAwareSecureService
@Component
public class SystemService {
    private final PortfolioExtensionLinkPersistence extensionLinkEntityPersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final ProjectExtension projectExtension;
    private final VersionExtension versionExtension;
    private final UserExtension userExtension;
    private final WorkItemExtension workItemExtension;
    private final FiltersExtension filtersExtension;

    @Autowired
    public SystemService(PortfolioExtensionLinkPersistence extensionLinkEntityPersistence, PortfolioWorkItemPersistence workItemPersistence, ProjectExtension projectExtension, VersionExtension versionExtension, UserExtension userExtension, WorkItemExtension workItemExtension, FiltersExtension filtersExtension) {
        this.extensionLinkEntityPersistence = extensionLinkEntityPersistence;
        this.workItemPersistence = workItemPersistence;
        this.projectExtension = projectExtension;
        this.versionExtension = versionExtension;
        this.userExtension = userExtension;
        this.workItemExtension = workItemExtension;
        this.filtersExtension = filtersExtension;
    }

    @POST
    @AuthorizedPlanReadAccess
    @Path(value="projects")
    public Response listProjects(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestProjectListRequest request) throws Exception {
        ProjectAccess access = ProjectAccess.from(request.getAccessType());
        ListProjectResult listProjectResult = this.projectExtension.listProjects(access, request.getQueryString(), request.getMaxResults(), request.getExcludedIds(), request.getLoadRequiredFields());
        return Response.ok((Object)RestProjectSearchResult.from(listProjectResult)).build();
    }

    @GET
    @AuthorizedPlanReadAccess
    @Path(value="defaultedproject")
    public Response getDefaultedProject(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, @QueryParam(value="accessType") String accessType, @QueryParam(value="projectId") Long projectId, @QueryParam(value="loadRequiredFields") Boolean loadRequiredFields) throws Exception {
        ProjectAccess access = ProjectAccess.from(accessType);
        ListProjectResult listProjectResult = this.projectExtension.getDefaultedProject(access, projectId, loadRequiredFields != null ? loadRequiredFields : false);
        return Response.ok((Object)RestProjectSearchResult.from(listProjectResult)).build();
    }

    @POST
    @AuthorizedPlanReadAccess
    @Path(value="versions")
    public Response listVersions(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestVersionListRequest request) throws Exception {
        ListVersionResult listVersionResult = this.versionExtension.findVersions(request.getProjectId(), request.getQueryString(), request.getExcludedIds(), request.getMaxResults());
        return Response.ok((Object)RestListVersionResponse.from(listVersionResult)).build();
    }

    @GET
    @AuthorizedPlanReadAccess
    @Path(value="filters")
    public Response listFilters(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, @QueryParam(value="queryString") String queryString) throws Exception {
        IssueFilterSearchResult searchResult = this.filtersExtension.listFilters(queryString);
        return Response.ok((Object)RestIssueFilterSearchResult.build(searchResult)).build();
    }

    @GET
    @AuthorizedPlanReadAccess
    @Path(value="getfilter")
    public Response getFilter(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, @QueryParam(value="filterId") Long filterId) throws Exception {
        IssueFilterDescription filter = this.filtersExtension.getFilter(filterId);
        if (filter != null) {
            return Response.ok((Object)RestIssueFilterDescription.build(filter)).build();
        }
        return Response.noContent().build();
    }

    @POST
    @AuthorizedPluginAdminAccess
    @Path(value="groupsandusers/system")
    public Response listGroupsAndUsersWithoutPlanPermissions(RestGroupAndUserListConfiguration config) throws Exception {
        return this.handleGroupsAndUsersRequest(config);
    }

    @POST
    @AuthorizedPlanReadAccess
    @Path(value="groupsandusers")
    public Response listGroupsAndUsers(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestGroupAndUserListConfiguration config) throws Exception {
        return this.handleGroupsAndUsersRequest(config);
    }

    private Response handleGroupsAndUsersRequest(RestGroupAndUserListConfiguration config) throws Exception {
        int MAX_RESULTS = 50;
        ArrayList groups = Lists.newArrayList();
        ArrayList users = Lists.newArrayList();
        groups.addAll(this.userExtension.listGroups(config.getQuery(), config.getExcludedGroups(), 51 - groups.size() - users.size()));
        if (Boolean.TRUE.equals(config.getIncludeUsers())) {
            users.addAll(this.userExtension.listUsers(config.getQuery(), config.getExcludedUsers(), 51 - groups.size() - users.size()));
        }
        boolean resultCut = false;
        if (groups.size() + users.size() > 50) {
            resultCut = true;
            if (users.size() > 0) {
                users.remove(users.size() - 1);
            } else {
                groups.remove(groups.size() - 1);
            }
        }
        RestGroupAndUserListResult result = new RestGroupAndUserListResult(users, groups, resultCut);
        return ResponseBuilder.ok(result);
    }

    @POST
    @AuthorizedPlanReadAccess
    @Path(value="import")
    public Response getIssuesForImport(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestImportRequest request) throws Exception {
        ArrayList items = Lists.newArrayList();
        long total = 0L;
        Boolean agileUnavailable = null;
        Boolean storyPointsUnavailable = null;
        IIssueSearchResult searchResult = this.workItemExtension.find(IssueRequest.createFromRestImportRequest(request, this.extensionLinkEntityPersistence));
        List extensionItems = Lists.transform(searchResult.getIssues(), RestImportResultEntry.TRANSFORMATION);
        items.addAll(extensionItems);
        total += searchResult.getResultSize();
        if (searchResult.isJiraAgileUnavailable()) {
            agileUnavailable = true;
        }
        if (searchResult.isStoryPointsFieldUnavailable()) {
            storyPointsUnavailable = true;
        }
        RestImportResult result = new RestImportResult(items, total, agileUnavailable, storyPointsUnavailable);
        return ResponseBuilder.ok(result);
    }

    @POST
    @AuthorizedPlanFullUserAccess(incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off, incrementEntityVersion=VersionIncrementMode.Off)
    @Path(value="issue")
    public Response createIssue(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestCreateIssueRequest request) throws Exception {
        try {
            CreateIssueResult result = this.workItemExtension.createIssue(request);
            return ResponseBuilder.ok(new RestCreateIssueResult(result.getIssueId(), result.getIssueKey()));
        }
        catch (CreateIssuePermissionException e) {
            return ResponseBuilder.badRequest(RestMessaging.error("jira-permission-violation"));
        }
    }

    @POST
    @AuthorizedPlanFullUserAccess(incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off, incrementEntityVersion=VersionIncrementMode.Off)
    @Path(value="version")
    public Response createVersion(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestCreateVersionRequest request) throws Exception {
        try {
            Long newVersionId = this.versionExtension.createVersion(request);
            RestCreateVersionResult result = new RestCreateVersionResult(newVersionId);
            return ResponseBuilder.ok(result);
        }
        catch (CreateVersionDuplicateNameException ex) {
            return ResponseBuilder.badRequest(RestMessaging.error("jira-duplicate-version-name"));
        }
        catch (CreateVersionReleaseDateBeforeStartDateException ex) {
            return ResponseBuilder.badRequest(RestMessaging.error("jira-version-release-before-start-date"));
        }
        catch (ProjectNotFoundException ex) {
            return ResponseBuilder.badRequest(RestMessaging.error("jira-project-not-found"));
        }
        catch (CreateVersionPermissionException ex) {
            return ResponseBuilder.badRequest(RestMessaging.error("jira-permission-violation"));
        }
    }

    @POST
    @AuthorizedPlanFullUserAccess(incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off, incrementEntityVersion=VersionIncrementMode.Off)
    @Path(value="issuelinks")
    public Response createIssueLinksForDependencies(@EntityParam(value=PortfolioPlanPersistence.class, idParameter="planId", idParameterType=ParameterType.Query) EntityContext<IPlan> entityContext, RestCreateIssueLinksForDependenciesRequest request) throws Exception {
        IssueLinkRequest linkRequest = DefaultCreateIssueLinksForDependenciesRequest.create(request.getWorkItemId(), request.getIssueKey(), request.getIssueLinkTypeId(), request.getIgnoredWorkItemIds(), this.extensionLinkEntityPersistence, this.workItemPersistence);
        CreateIssueLinksResult result = this.workItemExtension.createIssueLinksForDependencies(linkRequest);
        return ResponseBuilder.ok(RestCreateIssueLinksForDependenciesResult.from(result));
    }
}

