/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system.projects;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import com.radiantminds.roadmap.common.rest.services.system.projects.RestProjectIssueType;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="project")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestProject {
    @XmlElement
    private Long id;
    @XmlElement
    private String key;
    @XmlElement
    private String name;
    @XmlElement
    private String icon;
    @XmlElement
    private List<RestProjectIssueType> issueTypes;
    public static Function<ProjectData, RestProject> TRANSFORMATION = new Function<ProjectData, RestProject>(){

        public RestProject apply(@Nullable ProjectData projectData) {
            return RestProject.from(projectData);
        }
    };

    @Deprecated
    private RestProject() {
    }

    private RestProject(Long id, String key, String name, String icon, List<RestProjectIssueType> issueTypes) {
        this.icon = icon;
        this.id = id;
        this.key = key;
        this.name = name;
        this.issueTypes = issueTypes;
    }

    public static RestProject from(ProjectData projectData) {
        return new RestProject(projectData.getId(), projectData.getKey(), projectData.getName(), projectData.getIconUrl(), Lists.newArrayList((Iterable)Iterables.transform(projectData.getIssueTypes(), RestProjectIssueType.TRANSFORMATION)));
    }
}

