/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.streamrelease;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestReleaseStreamAssignment;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.streamrelease.WorkItemStreamReleaseServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/{id}/releasestream")
@Component
public class WorkItemStreamReleaseService {
    private final WorkItemStreamReleaseServiceHandler handler;

    @Autowired
    public WorkItemStreamReleaseService(OperationExecutor operationExecutor, SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioStreamPersistence streamPersistence) {
        this.handler = handlerFactory.createProxy(WorkItemStreamReleaseServiceHandler.class, new WorkItemStreamReleaseServiceHandler.Impl(operationExecutor, workItemPersistence, streamPersistence), workItemPersistence);
    }

    @PUT
    public Response setStreamReleaseAssignment(@PathParam(value="id") String workItemId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long expectedEntityVersion, @QueryParam(value="clientId") String clientId, RestReleaseStreamAssignment assignment) throws Exception {
        return this.handler.setAssignment(EntityContext.from(workItemId, expectedEntityVersion, expectedPlanVersion, clientId), assignment);
    }

    @PUT
    @Path(value="/replanning")
    public Response setReplanningStreamReleaseAssignment(@PathParam(value="id") String workItemId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long expectedEntityVersion, @QueryParam(value="clientId") String clientId, RestReleaseStreamAssignment assignment) throws Exception {
        return this.handler.setReplanningAssignment(EntityContext.from(workItemId, expectedEntityVersion, expectedPlanVersion, clientId), assignment);
    }

    @DELETE
    @Path(value="/replanning")
    public Response resetReplanningRelease(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.resetReplanningRelease(EntityContext.from(id, expectedPlanVersion, clientId));
    }
}

