/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioNonWorkingDaysPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import com.radiantminds.roadmap.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LocalSchedulingPlan
implements FullContentSchedulingPlan {
    private final String id;
    private final String title;
    private final String description;
    private final Long version;
    private final Long planVersion;
    private final Long schedulingVersion;
    private final Optional<Long> date;
    private final List<IStage> stages;
    private final List<ITeam> teams;
    private final List<IStream> streams;
    private final Map<String, IPerson> persons;
    private final List<IEstimationEnrichedWorkItem> workItems;
    private final LinkedHashMap<String, IEstimationEnrichedWorkItem> workItemMap;
    private final List<IEstimationEnrichedWorkItem> epics;
    private final List<IEstimationEnrichedWorkItem> stories;
    private IPlanConfiguration config;
    private final List<INonWorkingDay> nonWorkingDays;
    private final LinkedHashMap<String, SchedulingStage> stageMap;
    private final LinkedHashMap<String, SchedulingTeam> teamMap;
    private final LinkedHashMap<String, SchedulingStream> streamMap;

    LocalSchedulingPlan(String planId, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioThemePersistence themePersistence, PortfolioStagePersistence stagePersistence, PortfolioTeamPersistence teamPersistence, PortfolioStreamPersistence streamPersistence, PortfolioNonWorkingDaysPersistence nonWorkingDaysPersistence) throws Exception {
        IPlan plan = planPersistence.getPlanWithCustomQuery(planId, false);
        if (plan == null) {
            throw new PersistenceException("Plan not found");
        }
        this.id = plan.getId();
        this.title = plan.getTitle();
        this.description = plan.getDetails();
        this.version = plan.getVersion();
        this.planVersion = plan.getPlanVersion();
        this.schedulingVersion = plan.getSchedulingVersion();
        this.date = plan.getDate();
        this.config = planPersistence.getPlanConfiguration(planId);
        this.stages = stagePersistence.listCustom(planId);
        this.teams = teamPersistence.listCustomWithPersons(planId, false);
        this.streams = streamPersistence.listCustomWithReleases(planId);
        List<ITheme> themes = themePersistence.listCustom(planId);
        this.persons = Maps.newHashMap();
        for (ITeam iTeam : this.teams) {
            for (IResource resource : iTeam.getResources()) {
                this.persons.put(resource.getPersonId(), resource.getPerson());
            }
        }
        this.epics = Lists.newArrayList();
        for (IWorkItem iWorkItem : workItemPersistence.listPlainWorkItemsForPlan(planId)) {
            this.epics.add((IEstimationEnrichedWorkItem)iWorkItem);
        }
        this.workItems = LocalSchedulingPlan.flatten(this.epics);
        this.stories = Lists.newArrayList();
        for (IEstimationEnrichedWorkItem iEstimationEnrichedWorkItem : this.workItems) {
            if (!iEstimationEnrichedWorkItem.getType().equals(WorkItems.Types.STORY)) continue;
            this.stories.add(iEstimationEnrichedWorkItem);
        }
        this.workItemMap = Maps.newLinkedHashMap();
        for (IEstimationEnrichedWorkItem iEstimationEnrichedWorkItem : this.workItems) {
            this.workItemMap.put(iEstimationEnrichedWorkItem.getId(), iEstimationEnrichedWorkItem);
        }
        Map<String, ITeam> teamsMap = CommonUtils.createIdMap(this.teams);
        Map<String, IStream> map = CommonUtils.createIdMap(this.streams);
        Map<String, IRelease> releasesMap = CommonUtils.createReleaseMap(this.streams);
        Map<String, ITheme> themesMap = CommonUtils.createIdMap(themes);
        for (IWorkItem iWorkItem : this.workItems) {
            String themeId;
            String streamId;
            Optional<String> teamId;
            String releaseId = iWorkItem.getReleaseId();
            if (releaseId != null) {
                iWorkItem.setRelease(releasesMap.get(releaseId));
            }
            if ((teamId = iWorkItem.getTeamId()).isPresent()) {
                iWorkItem.setTeam(teamsMap.get(teamId.get()));
            }
            if ((streamId = iWorkItem.getStreamId()) != null) {
                iWorkItem.setStream(map.get(streamId));
            }
            if ((themeId = (String)iWorkItem.getThemeId().orNull()) == null) continue;
            iWorkItem.setTheme(themesMap.get(themeId));
        }
        this.stageMap = Maps.newLinkedHashMap();
        for (IStage iStage : this.stages) {
            this.stageMap.put(iStage.getId(), iStage);
        }
        this.teamMap = Maps.newLinkedHashMap();
        for (ITeam iTeam : this.teams) {
            this.teamMap.put(iTeam.getId(), iTeam);
        }
        this.streamMap = Maps.newLinkedHashMap();
        for (IStream iStream : this.streams) {
            this.streamMap.put(iStream.getId(), iStream);
        }
        this.nonWorkingDays = this.deRest(nonWorkingDaysPersistence.listForPlan(planId));
    }

    private List<INonWorkingDay> deRest(List<RestNonWorkingDay> restNonWorkingDays) {
        ArrayList deRested = Lists.newArrayList();
        for (RestNonWorkingDay restNonWorkingDay : restNonWorkingDays) {
            deRested.add(restNonWorkingDay);
        }
        return deRested;
    }

    @Override
    public Long getPlanVersion() {
        return this.planVersion;
    }

    public Optional<IPerson> getPerson(String personId) {
        return Optional.fromNullable((Object)this.persons.get(personId));
    }

    @Override
    public void setPlanVersion(Long planVersion) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Long getSchedulingVersion() {
        return this.schedulingVersion;
    }

    @Override
    public void setSchedulingVersion(Long schedulingVersion) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Optional<Long> getDate() {
        return this.date;
    }

    @Override
    public void setDate(Long date) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Optional<Long> getReplanningDate() {
        return (Optional)LocalSchedulingPlan.notAvailable();
    }

    @Override
    public void setReplanningDate(Long date) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Boolean getInReplanning() {
        return (Boolean)LocalSchedulingPlan.notAvailable();
    }

    @Override
    public void setInReplanning(Boolean val) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Long getReplanningVersion() {
        return (Long)LocalSchedulingPlan.notAvailable();
    }

    @Override
    public void setReplanningVersion(Long version) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Boolean getInStreamMode() {
        return (Boolean)LocalSchedulingPlan.notAvailable();
    }

    @Override
    public void setInStreamMode(Boolean inStreamMode) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public List<ITheme> getThemes() {
        throw new RuntimeException("getThemes() is not allowed on SchedulingPlan. TBI if needed.");
    }

    @Override
    public List<INonWorkingDay> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    @Override
    public List<IPerson> getPersons() {
        return Lists.newArrayList(this.persons.values());
    }

    @Override
    public List<IStage> getStages() {
        return this.stages;
    }

    @Override
    public List<ITeam> getTeams() {
        return this.teams;
    }

    @Override
    public List<IStream> getStreams() {
        return this.streams;
    }

    @Override
    public List<IWorkItem> getWorkItems() {
        return Collections.unmodifiableList(Lists.newArrayList(this.workItems));
    }

    @Override
    public List<IWorkItem> getEpics() {
        return Collections.unmodifiableList(Lists.newArrayList(this.epics));
    }

    @Override
    public List<IWorkItem> getStories() {
        return Collections.unmodifiableList(Lists.newArrayList(this.stories));
    }

    @Override
    public Map<String, IWorkItem> getWorkItemMap() {
        return Collections.unmodifiableMap(Maps.newHashMap(this.workItemMap));
    }

    @Override
    public IPlanConfiguration getPlanConfiguration() {
        return this.config;
    }

    @Override
    public Optional<? extends SchedulingWorkItem> getWorkItem(String id) {
        return Optional.fromNullable((Object)this.workItemMap.get(id));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public String getDetails() {
        return this.description;
    }

    @Override
    public void setDetails(String description) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void clearReplanning(ActiveObjectsUtilities utils) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public void applyReplanning(ActiveObjectsUtilities utils, Long replanningDate) {
        LocalSchedulingPlan.notAllowed();
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        LocalSchedulingPlan.notAllowed();
    }

    private static void notAllowed() {
        throw new RuntimeException("Scheduling plans are read-only. Operation not allowed.");
    }

    private static <T> T notAvailable() {
        throw new RuntimeException("Data not relevant for scheduling is not available on scheduling plans. Operation not implemented. This is not the method you're looking for. Move along.");
    }

    private static List<IEstimationEnrichedWorkItem> flatten(List<? extends IWorkItem> workItems) {
        ArrayList retVal = Lists.newArrayList();
        for (IWorkItem iWorkItem : workItems) {
            retVal.add((IEstimationEnrichedWorkItem)iWorkItem);
            if (iWorkItem.getChildren() == null) continue;
            retVal.addAll(LocalSchedulingPlan.flatten(iWorkItem.getChildren()));
        }
        return retVal;
    }

    @Override
    public List<IEstimationEnrichedWorkItem> getEstimationEnrichedWorkItems() {
        return this.workItems;
    }

    @Override
    public List<IEstimationEnrichedWorkItem> getEstimationEnrichedEpics() {
        return this.epics;
    }
}

