/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IScheduleAnnotations;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IScheduleStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ScheduleCapacityStatistic;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.Interval;

@Immutable
class PlanSolution
implements IPlanSolution {
    private final Long schedulingVersion;
    private final Set<ISchedulingAssignment> schedulingAssignments;
    private final IScheduleAnnotations scheduleAnnotations;
    private final IScheduleStatistics scheduleStatistics;
    private final long planStartTimestamp;
    private final Map<String, Interval> releaseIntervals;
    private final ScheduleCapacityStatistic capacityData;

    PlanSolution(Long schedulingVersion, Set<ISchedulingAssignment> schedulingAssignments, IScheduleAnnotations scheduleAnnotations, IScheduleStatistics scheduleStatistics, Map<String, Interval> releaseIntervals, long planStartTimestamp, ScheduleCapacityStatistic capacityData) {
        this.schedulingVersion = schedulingVersion;
        this.schedulingAssignments = Collections.unmodifiableSet(schedulingAssignments);
        this.scheduleAnnotations = scheduleAnnotations;
        this.scheduleStatistics = scheduleStatistics;
        this.releaseIntervals = releaseIntervals;
        this.planStartTimestamp = planStartTimestamp;
        this.capacityData = capacityData;
    }

    @Override
    public Long getSchedulingVersion() {
        return this.schedulingVersion;
    }

    @Override
    public Set<ISchedulingAssignment> getSchedulingAssignments() {
        return this.schedulingAssignments;
    }

    @Override
    public IScheduleAnnotations getScheduleAnnotations() {
        return this.scheduleAnnotations;
    }

    @Override
    public IScheduleStatistics getPlanStatistics() {
        return this.scheduleStatistics;
    }

    @Override
    public long getPlanStartTimestamp() {
        return this.planStartTimestamp;
    }

    @Override
    public Set<String> getItemIdsForTeamIds(@Nullable Collection<String> teamIds) {
        if (teamIds == null) {
            return Sets.newHashSet();
        }
        final HashSet ids = Sets.newHashSet(teamIds);
        Set filteredAssignments = Sets.filter(this.schedulingAssignments, (Predicate)new Predicate<ISchedulingAssignment>(){

            public boolean apply(ISchedulingAssignment input) {
                return ids.contains(input.getTeamId());
            }
        });
        return this.getItemIds(filteredAssignments);
    }

    private Set<String> getItemIds(Set<ISchedulingAssignment> filteredAssignments) {
        HashSet itemIds = Sets.newHashSet();
        for (ISchedulingAssignment assignment : filteredAssignments) {
            itemIds.add(assignment.getWorkItemId());
        }
        return itemIds;
    }

    @Override
    public Set<String> getItemsIdsForReleseIds(@Nullable Collection<String> releaseIds) {
        if (releaseIds == null) {
            return Sets.newHashSet();
        }
        final HashSet ids = Sets.newHashSet(releaseIds);
        Set filteredAssignments = Sets.filter(this.schedulingAssignments, (Predicate)new Predicate<ISchedulingAssignment>(){

            public boolean apply(ISchedulingAssignment input) {
                return ids.contains(input.getReleaseId());
            }
        });
        return this.getItemIds(filteredAssignments);
    }

    @Override
    public Set<String> getReleases(String itemId) {
        HashSet releaseIds = Sets.newHashSet();
        for (ISchedulingAssignment assignment : this.schedulingAssignments) {
            if (!assignment.getWorkItemId().equals(itemId)) continue;
            releaseIds.add(assignment.getReleaseId());
        }
        return releaseIds;
    }

    @Override
    public Set<String> getTeamIds(String itemId) {
        HashSet teamIds = Sets.newHashSet();
        for (ISchedulingAssignment assignment : this.schedulingAssignments) {
            if (!assignment.getWorkItemId().equals(itemId)) continue;
            teamIds.add(assignment.getTeamId());
        }
        return teamIds;
    }

    @Override
    public Set<String> getResources(String itemId) {
        HashSet resourceIds = Sets.newHashSet();
        for (ISchedulingAssignment assignment : this.schedulingAssignments) {
            if (!assignment.getWorkItemId().equals(itemId)) continue;
            resourceIds.add(assignment.getResourceId());
        }
        return resourceIds;
    }

    @Override
    public Optional<Interval> getReleaseInterval(String releaseId) {
        Interval interval = this.releaseIntervals.get(releaseId);
        if (interval == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)interval);
    }

    @Override
    public ScheduleCapacityStatistic getCapacityData() {
        return this.capacityData;
    }
}

