/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IReleaseStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IResourceTypeDescription;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.WorkStatistics;
import javax.annotation.concurrent.Immutable;

@Immutable
class ReleaseStatistics
extends WorkStatistics
implements IReleaseStatistics {
    private final String releaseId;
    private final Double overbookedWork;

    ReleaseStatistics(String releaseId, PlanningUnit planningUnit, double avgResourceUtilization, double workLoad, double availableWork, PositivePrimitivesMap<IResourceTypeDescription> freeTypes, Double overbookedWork) {
        super(planningUnit, avgResourceUtilization, workLoad, availableWork, freeTypes);
        this.releaseId = releaseId;
        this.overbookedWork = overbookedWork;
    }

    @Override
    public String getId() {
        return this.releaseId;
    }

    @Override
    public Optional<Double> getOverBookedWork() {
        return Optional.fromNullable((Object)this.overbookedWork);
    }

    @Override
    public double getUtilization() {
        if (this.overbookedWork == null) {
            return super.getUtilization();
        }
        if (this.getAvailableWork() <= 0.0) {
            return 1.0;
        }
        return (this.getWorkLoad() - this.overbookedWork) / this.getAvailableWork();
    }
}

