/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.WorkAssignmentWrapper;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ResourceSprintStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.ResourceIntervalCapacityStatistic;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class ConvertingResourceSprintStatistic
implements ResourceSprintStatistic {
    private final ResourceIntervalCapacityStatistic wrapped;
    private final ITimeTransformer timeTransformer;

    ConvertingResourceSprintStatistic(ResourceIntervalCapacityStatistic statistic, ITimeTransformer timeTransformer) {
        this.wrapped = statistic;
        this.timeTransformer = timeTransformer;
    }

    @Override
    public float getCapacity() {
        return this.timeTransformer.getWorkInPlanningUnit(this.wrapped.getCapacity());
    }

    @Override
    public Set<ISchedulingAssignment> getSchedulingAssignments() {
        return this.convertWorkAssignments(this.wrapped.getWorkAssignments());
    }

    private Set<ISchedulingAssignment> convertWorkAssignments(Set<IWorkAssignment> workAssignments) {
        HashSet transformed = Sets.newHashSet();
        for (IWorkAssignment workAssignment : workAssignments) {
            transformed.add(new WorkAssignmentWrapper(workAssignment, this.timeTransformer));
        }
        return transformed;
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }
}

