/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.rm.jpo.scheduling.util.DefaultIdentifiableInterval;
import com.atlassian.rm.jpo.scheduling.util.IdentifiableInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.SprintComparator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ValidSprintPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class SprintDefinitionTransformer {
    private static final Ordering<ISprint> SPRINT_ORDERING = Ordering.from((Comparator)new SprintComparator());
    private final ITimeTransformer timeTransformer;
    private final ValidSprintPredicate validSprintPredicate;

    SprintDefinitionTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
        this.validSprintPredicate = new ValidSprintPredicate(timeTransformer.getInstant(0));
    }

    List<IdentifiableInterval> transformSprints(Collection<ISprint> sprints) {
        Iterable validSprints = Iterables.filter(sprints, (Predicate)this.validSprintPredicate);
        ImmutableList sortedSprints = SPRINT_ORDERING.immutableSortedCopy(validSprints);
        return this.createValidSprintIntervals((ImmutableList<ISprint>)sortedSprints);
    }

    private List<IdentifiableInterval> createValidSprintIntervals(ImmutableList<ISprint> sortedSprints) {
        int earliestNextStart = Integer.MIN_VALUE;
        ArrayList validWorkSlots = Lists.newArrayList();
        for (ISprint validSprint : sortedSprints) {
            int endTimeStep = this.timeTransformer.getTimestep(validSprint.getEndDate());
            if (endTimeStep < earliestNextStart) continue;
            int startTimeStep = this.timeTransformer.getZeroInstantSafeTimestep(validSprint.getStartDate());
            IntegerInterval interval = new IntegerInterval(Math.max(startTimeStep, earliestNextStart), endTimeStep);
            DefaultIdentifiableInterval namedInterval = new DefaultIdentifiableInterval(interval, validSprint.getId());
            validWorkSlots.add(namedInterval);
            earliestNextStart = endTimeStep + 1;
        }
        return validWorkSlots;
    }
}

