/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.FixedGroupPointsResourceSupplyFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.LinearTeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TeamAvailabilityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.PersonMapping;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.WorkFunctionCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.LinearTeamVelocityFunctionFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceRatioSupplyFunctionCreator {
    private static final Log LOGGER = Log.with(ResourceRatioSupplyFunctionCreator.class);
    private final WorkFunctionCreator workFunctionCreator;
    private final TimeStepPresenceFunction timeStepPresenceFunction;

    ResourceRatioSupplyFunctionCreator(WorkFunctionCreator workFunctionCreator, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.workFunctionCreator = workFunctionCreator;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    public ResourceRatioSupplyFunctionCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new WorkFunctionCreator(timeTransformer, timeStepPresenceFunction), timeStepPresenceFunction);
    }

    public Map<SchedulingResource, IWorkSlotFunction> getResourceSupplyFunctions(SchedulingTeam team, PersonMapping personMapping, WorkSlotsDefinition workSlotsDefinition, float velocity) {
        Preconditions.checkNotNull(team.getResources(), (Object)"resources must not be null");
        Preconditions.checkArgument((!team.getResources().isEmpty() ? 1 : 0) != 0, (Object)"resources must be available");
        LOGGER.debug("create resource functions for team: %s", team);
        LinearTeamVelocityFunction teamVelocity = LinearTeamVelocityFunctionFactory.createInstance(team, velocity, workSlotsDefinition, this.timeStepPresenceFunction);
        HashMap supplies = Maps.newHashMap();
        Map<SchedulingResource, IWorkSlotFunction> availabilities = this.getSupplies(team.getResources(), personMapping, workSlotsDefinition);
        TeamAvailabilityFunction teamAvailabilityFunction = TeamAvailabilityFunction.createInstance(availabilities.values());
        for (Map.Entry<SchedulingResource, IWorkSlotFunction> entry : availabilities.entrySet()) {
            FixedGroupPointsResourceSupplyFunction availability = new FixedGroupPointsResourceSupplyFunction(entry.getValue(), teamAvailabilityFunction, teamVelocity);
            supplies.put(entry.getKey(), availability);
            LOGGER.debug("created for resource %s: %s", entry.getKey().getId(), availabilities);
        }
        return supplies;
    }

    public Map<SchedulingResource, IWorkSlotFunction> getResourceSupplyFunctions(SchedulingTeam team, PersonMapping personMapping, WorkSlotsDefinition workSlotsDefinition, float velocity, float increment) {
        Preconditions.checkNotNull(team.getResources(), (Object)"resources must not be null");
        Preconditions.checkArgument((!team.getResources().isEmpty() ? 1 : 0) != 0, (Object)"resources must be available");
        LOGGER.debug("create resource functions for team: %s", team);
        LinearTeamVelocityFunction teamVelocity = new LinearTeamVelocityFunction(velocity, increment, workSlotsDefinition, this.timeStepPresenceFunction);
        HashMap supplies = Maps.newHashMap();
        Map<SchedulingResource, IWorkSlotFunction> availabilities = this.getSupplies(team.getResources(), personMapping, workSlotsDefinition);
        TeamAvailabilityFunction teamAvailabilityFunction = TeamAvailabilityFunction.createInstance(availabilities.values());
        for (Map.Entry<SchedulingResource, IWorkSlotFunction> entry : availabilities.entrySet()) {
            FixedGroupPointsResourceSupplyFunction availability = new FixedGroupPointsResourceSupplyFunction(entry.getValue(), teamAvailabilityFunction, teamVelocity);
            supplies.put(entry.getKey(), availability);
            LOGGER.debug("created for resource %s: %s", entry.getKey().getId(), availabilities);
        }
        return supplies;
    }

    private Map<SchedulingResource, IWorkSlotFunction> getSupplies(List<? extends SchedulingResource> resources, PersonMapping personMapping, WorkSlotsDefinition workSlotsDefinition) {
        HashMap availabilities = Maps.newHashMap();
        for (SchedulingResource schedulingResource : resources) {
            SchedulingPerson person;
            IWorkSlotFunction resourceAvailabilityFunction = (IWorkSlotFunction)this.workFunctionCreator.tryCreateWorkSlotAvailability(schedulingResource, person = (SchedulingPerson)personMapping.getPerson(schedulingResource.getPersonId()).get(), workSlotsDefinition).orNull();
            if (resourceAvailabilityFunction == null) continue;
            availabilities.put(schedulingResource, resourceAvailabilityFunction);
        }
        return availabilities;
    }
}

