/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.status;

import com.atlassian.jira.issue.status.Status;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.status.JiraStatusUtil;
import com.radiantminds.roadmap.jira.common.components.utils.IconURLs;
import javax.annotation.Nullable;

public class JiraIssueStatusData
implements StatusData {
    private final String id;
    private final String name;
    private final String iconUrl;
    private final String categoryKey;
    private final String categoryColor;
    private final boolean done;

    private JiraIssueStatusData(String id, String name, String iconUrl, @Nullable String categoryKey, @Nullable String categoryColor, boolean done) {
        this.id = id;
        this.name = name;
        this.iconUrl = iconUrl;
        this.categoryKey = categoryKey;
        this.categoryColor = categoryColor;
        this.done = done;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public Optional<String> getCategoryKey() {
        return Optional.fromNullable((Object)this.categoryKey);
    }

    @Override
    public Optional<String> getCategoryColor() {
        return Optional.fromNullable((Object)this.categoryColor);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public static StatusData createInstance(Status status, String baseUrl) {
        String categoryKey = status.getStatusCategory().getKey();
        String categoryColor = status.getStatusCategory().getColorName();
        JiraIssueStatusData instance = new JiraIssueStatusData(status.getId(), status.getName(), IconURLs.adapt(baseUrl, status.getIconUrlHtml()), categoryKey, categoryColor, JiraStatusUtil.isDone(status));
        return instance;
    }
}

