/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.IssueLinkUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.exceptions.InvalidIssueLinkTypeException;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.SyncIssueLinksRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class SyncIssueLinksRequestHandler {
    private static final Log LOGGER = Log.with(SyncIssueLinksRequestHandler.class);
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkService issueLinkService;
    private final IssueLinkServiceBridge issueLinkServiceBridge;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueServiceBridge issueServiceBridge;
    private final PermissionManager permissionManager;
    private final FeatureExtension featureExtension;

    public SyncIssueLinksRequestHandler(IssueLinkManager issueLinkManager, IssueLinkService issueLinkService, IssueLinkServiceBridge issueLinkServiceBridge, IssueLinkTypeManager issueLinkTypeManager, IssueServiceBridge issueServiceBridge, PermissionManager permissionManager, FeatureExtension featureExtension) {
        this.issueLinkManager = issueLinkManager;
        this.issueLinkService = issueLinkService;
        this.issueLinkServiceBridge = issueLinkServiceBridge;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueServiceBridge = issueServiceBridge;
        this.permissionManager = permissionManager;
        this.featureExtension = featureExtension;
    }

    public List<ViolationMessage> syncIssueLinks(SyncIssueLinksRequest request) {
        Direction direction;
        IssueLinkType issueLinkType;
        ArrayList violations = Lists.newArrayList();
        if (!this.issueLinkManager.isLinkingEnabled()) {
            LOGGER.warn("Cannot create issue links, Jira issue linking is disabled.", new Object[0]);
            violations.add(new ViolationMessage.Impl("error", "jira-issue-linking-disabled"));
            return violations;
        }
        if (!this.permissionManager.hasPermission(21, request.getIssue().getProjectObject(), request.getApplicationUser())) {
            LOGGER.warn("Cannot create issue links, Jira issue linking is disabled.", new Object[0]);
            String projectDetails = "undefined project";
            Project project = request.getIssue().getProjectObject();
            if (project != null) {
                projectDetails = project.getName() + " (" + project.getKey() + ")";
            } else {
                LOGGER.warn("No project associated with the issue '%s'.", request.getIssue().getKey());
            }
            violations.add(new ViolationMessage.Impl("warning", "jira-issue-linking-not-allowed-in-project", projectDetails));
            return violations;
        }
        try {
            issueLinkType = IssueLinkUtils.getIssueLinkType(this.issueLinkTypeManager, request.getIssueLinkTypeId());
        }
        catch (InvalidIssueLinkTypeException e) {
            LOGGER.warn("Cannot create issue links, issueLinkType with id '%s' was not found.", request.getIssueLinkTypeId());
            violations.add(new ViolationMessage.Impl("error", "jira-issue-linking-invalid-type"));
            return violations;
        }
        if (request.getInwardLinksIssueKeys().isEmpty() && request.getOutwardLinksIssueKeys().isEmpty() && !request.isDeleteExistintIssueLinks()) {
            return violations;
        }
        HashSet errorMessages = Sets.newHashSet();
        ApplicationUser user = request.getApplicationUser();
        if (request.isDeleteExistintIssueLinks()) {
            errorMessages.addAll(IssueLinkUtils.deleteIssueLinks(this.issueLinkService, this.issueLinkServiceBridge, user, request.getIssue(), issueLinkType));
        }
        if (request.getInwardLinksIssueKeys().size() > 0) {
            direction = Direction.IN;
            if (this.featureExtension.isInvertedDependencyCreationEnabled()) {
                direction = IssueLinkUtils.getInvertedIssueLinkDirection(direction);
            }
            errorMessages.addAll(IssueLinkUtils.createIssueLinks(this.issueLinkServiceBridge, user, request.getIssue(), issueLinkType, direction, request.getInwardLinksIssueKeys()));
        }
        if (request.getOutwardLinksIssueKeys().size() > 0) {
            direction = Direction.OUT;
            if (this.featureExtension.isInvertedDependencyCreationEnabled()) {
                direction = IssueLinkUtils.getInvertedIssueLinkDirection(direction);
            }
            errorMessages.addAll(IssueLinkUtils.createIssueLinks(this.issueLinkServiceBridge, user, request.getIssue(), issueLinkType, direction, request.getOutwardLinksIssueKeys()));
        }
        if (errorMessages.size() > 0) {
            Iterator errorMessagesIterator = errorMessages.iterator();
            while (errorMessagesIterator.hasNext()) {
                violations.add(new ViolationMessage.Impl("raw", (String)errorMessagesIterator.next()));
            }
        }
        return violations;
    }
}

