/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.versions;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.rm.common.bridges.jira.project.ProjectManagerBridge;
import com.atlassian.rm.common.bridges.jira.project.ProjectManagerBridgeProxy;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.project.version.VersionBuilderBridge;
import com.atlassian.rm.common.bridges.jira.project.version.VersionServiceBridge;
import com.atlassian.rm.common.bridges.jira.project.version.VersionServiceBridgeProxy;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.projects.ProjectNotFoundException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionDuplicateNameException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionPermissionException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionReleaseDateBeforeStartDateException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionRequest;
import com.radiantminds.roadmap.common.extensions.versions.ListVersionResult;
import com.radiantminds.roadmap.common.extensions.versions.UnhandledCreateVersionErrorException;
import com.radiantminds.roadmap.common.extensions.versions.VersionData;
import com.radiantminds.roadmap.common.extensions.versions.VersionExtension;
import com.radiantminds.roadmap.jira.common.components.utils.JiraTimeZoneUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraVersionExtension
implements VersionExtension {
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;
    private final ProjectManagerBridgeProxy projectManagerBridgeProxy;
    private final VersionManager versionManager;
    private final VersionServiceBridgeProxy versionServiceBridgeProxy;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;

    @Autowired
    public JiraVersionExtension(ProjectServiceBridgeProxy projectServiceBridgeProxy, ProjectManagerBridgeProxy projectManagerBridgeProxy, VersionManager versionManager, VersionServiceBridgeProxy versionServiceBridgeProxy, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager) {
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
        this.projectManagerBridgeProxy = projectManagerBridgeProxy;
        this.versionManager = versionManager;
        this.versionServiceBridgeProxy = versionServiceBridgeProxy;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
    }

    @Override
    public ListVersionResult findVersions(Long projectId, String searchTerm, Set<Long> excluded, Integer maxResults) {
        excluded = (Set)MoreObjects.firstNonNull(excluded, (Object)Sets.newHashSet());
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        ProjectService.GetProjectResult getProjectResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).getProjectById(applicationUser, projectId);
        if (!getProjectResult.isValid()) {
            return ListVersionResult.EMPTY;
        }
        List versions = this.versionManager.getVersions(getProjectResult.getProject());
        ArrayList filteredVersions = Lists.newArrayList();
        for (Version version : versions) {
            String name;
            if (excluded.contains(version.getId()) || searchTerm != null && ((name = version.getName()) == null || !name.toLowerCase().contains(searchTerm.toLowerCase()))) continue;
            filteredVersions.add(version);
            if (filteredVersions.size() != maxResults + 1) continue;
            break;
        }
        final TimeZone jiraTimeZone = JiraTimeZoneUtil.getJiraDefaultTimeZone(this.applicationProperties);
        Iterable versionData = Iterables.transform((Iterable)Iterables.limit((Iterable)filteredVersions, (int)maxResults), (Function)new Function<Version, VersionData>(){

            public VersionData apply(@Nullable Version version) {
                Date correctedStartDate = version.getStartDate() != null ? JiraTimeZoneUtil.addTimeZoneOffset(version.getStartDate(), jiraTimeZone) : null;
                Date correctedReleaseDate = version.getReleaseDate() != null ? JiraTimeZoneUtil.addTimeZoneOffset(version.getReleaseDate(), jiraTimeZone) : null;
                return new VersionData.Impl(version.getId(), version.getName(), version.getDescription(), correctedStartDate, correctedReleaseDate);
            }
        });
        final ArrayList returnList = Lists.newArrayList((Iterable)versionData);
        final boolean moreAvailable = filteredVersions.size() > maxResults;
        return new ListVersionResult(){

            @Override
            public List<VersionData> getVersions() {
                return returnList;
            }

            @Override
            public boolean isMoreAvailable() {
                return moreAvailable;
            }
        };
    }

    @Override
    public Long createVersion(@Nonnull CreateVersionRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        VersionServiceBridge versionServiceBridge = (VersionServiceBridge)this.versionServiceBridgeProxy.get();
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        Project project = ((ProjectManagerBridge)this.projectManagerBridgeProxy.get()).getProjectObj(request.getProjectId());
        if (project == null) {
            throw new ProjectNotFoundException();
        }
        Collection authorizedProjects = this.permissionManager.getProjects(23, applicationUser);
        if (!authorizedProjects.contains(project)) {
            throw new CreateVersionPermissionException();
        }
        Date startDateJIRA = null;
        Date releaseDateJIRA = null;
        TimeZone jiraTimeZone = JiraTimeZoneUtil.getJiraDefaultTimeZone(this.applicationProperties);
        if (request.getStartDateUTC() != null) {
            DateTime startDateUTC = new DateTime((Object)request.getStartDateUTC(), DateTimeZone.UTC);
            startDateJIRA = JiraTimeZoneUtil.removeTimeZoneOffset(startDateUTC.toDate(), jiraTimeZone);
        }
        if (request.getEndDateUTC() != null) {
            DateTime releaseDateUTC = new DateTime((Object)request.getEndDateUTC(), DateTimeZone.UTC);
            releaseDateJIRA = JiraTimeZoneUtil.removeTimeZoneOffset(releaseDateUTC.toDate(), jiraTimeZone);
        }
        VersionBuilderBridge versionBuilder = versionServiceBridge.newVersionBuilder();
        versionBuilder.name(request.getName()).description(request.getDescription()).startDate(startDateJIRA).releaseDate(releaseDateJIRA).projectId(request.getProjectId());
        VersionService.VersionBuilderValidationResult versionBuilderValidationResult = versionServiceBridge.validateCreate(applicationUser, versionBuilder);
        if (versionBuilderValidationResult.isValid()) {
            ServiceOutcome<Version> versionServiceOutcome = versionServiceBridge.create(applicationUser, versionBuilderValidationResult);
            if (versionServiceOutcome.isValid()) {
                return ((Version)versionServiceOutcome.getReturnedValue()).getId();
            }
            throw this.checkErrorCollection(versionServiceOutcome.getErrorCollection());
        }
        throw this.checkErrorCollection(versionBuilderValidationResult.getErrorCollection());
    }

    @Override
    public Long getProjectIdForVersion(Long version) {
        Version jiraVersion = this.versionManager.getVersion(version);
        if (jiraVersion == null) {
            return null;
        }
        return jiraVersion.getProjectId();
    }

    private Exception checkErrorCollection(ErrorCollection collection) {
        if (collection.getErrors().containsKey("name")) {
            return new CreateVersionDuplicateNameException();
        }
        if (collection.getErrors().containsKey("releaseDate") || collection.getErrors().containsKey("startDate")) {
            return new CreateVersionReleaseDateBeforeStartDateException();
        }
        return new UnhandledCreateVersionErrorException(Joiner.on((String)"; ").join((Iterable)collection.getErrorMessages()));
    }
}

