/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.utils;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.security.groups.GroupManager;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPermissionService {
    private static String JIRA_USERS = "jira-users";
    private static String JIRA_ADMINISTRATORS = "jira-administrators";
    private static String JIRA_CORE_USERS = "jira-core-users";
    private static String JIRA_SOFTWARE_USERS = "jira-software-users";
    private static final String[] DEFAULT_GROUPS = new String[]{JIRA_ADMINISTRATORS, JIRA_USERS, JIRA_CORE_USERS, JIRA_SOFTWARE_USERS};
    private final GroupManager groupManager;
    private final PortfolioPermissionPersistence permissionPersistence;

    @Autowired
    public DefaultPermissionService(GroupManager groupManager, PortfolioPermissionPersistence permissionPersistence) {
        this.groupManager = groupManager;
        this.permissionPersistence = permissionPersistence;
    }

    public void setDefaultEditorPermissions() throws PersistenceException, SQLException {
        for (String groupName : DEFAULT_GROUPS) {
            Group group = this.groupManager.getGroup(groupName);
            if (group == null) continue;
            RestPermission jiraUsersPermission = RestPermission.createPluginFullEditorGroupPermission(group.getName());
            this.addIfNotExists(jiraUsersPermission);
        }
    }

    public void setDefaultLabsPermissions() throws PersistenceException, SQLException {
        for (String groupName : DEFAULT_GROUPS) {
            Group group = this.groupManager.getGroup(groupName);
            if (group == null) continue;
            RestPermission labsPermission = RestPermission.createPluginLabsAccessGroupPermission(group.getName());
            this.addIfNotExists(labsPermission);
            RestPermission teamManagementPermission = RestPermission.createTeamManagementAccessGroupPermission(group.getName());
            this.addIfNotExists(teamManagementPermission);
        }
    }

    private void addIfNotExists(IPermission permission) throws SQLException, PersistenceException {
        if (!this.permissionPersistence.exists(permission)) {
            this.permissionPersistence.persistCached(permission);
        }
    }
}

