/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import org.javasimon.callback.logging.DelegateLogTemplate;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.clock.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodicLogTemplate<C>
extends DelegateLogTemplate<C> {
    private final long period;
    private final Clock clock;
    private long nextTime;

    public PeriodicLogTemplate(LogTemplate<C> delegate, long period) {
        this(delegate, period, Clock.SYSTEM);
    }

    public PeriodicLogTemplate(LogTemplate<C> delegate, long period, Clock clock) {
        super(delegate);
        this.period = period;
        this.clock = clock;
        this.initNextTime();
    }

    public long getNextTime() {
        return this.nextTime;
    }

    long getCurrentTime() {
        return this.clock.milliTime();
    }

    private synchronized void initNextTime() {
        this.nextTime = this.getCurrentTime() + this.period;
    }

    public synchronized boolean isNextTimePassed() {
        return this.nextTime < this.getCurrentTime();
    }

    @Override
    protected boolean isEnabled(C context) {
        return super.isEnabled(context) && this.isNextTimePassed();
    }

    @Override
    protected void log(String message) {
        super.log(message);
        this.initNextTime();
    }
}

