/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.Counter;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.jmx.AbstractSimonMXBeanImpl;
import org.javasimon.jmx.CounterMXBeanImpl;
import org.javasimon.jmx.SimonSuperMXBean;
import org.javasimon.jmx.StopwatchMXBeanImpl;

public class JmxRegisterCallback
extends CallbackSkeleton {
    protected String domain;
    protected MBeanServer mBeanServer;
    private Set<String> registeredNames = new HashSet<String>();
    private boolean registerExisting;
    private Manager manager;

    public JmxRegisterCallback(String domain) {
        this(ManagementFactory.getPlatformMBeanServer(), domain);
    }

    public JmxRegisterCallback(MBeanServer mBeanServer, String domain) {
        assert (domain != null && !domain.isEmpty());
        this.mBeanServer = mBeanServer;
        this.domain = domain;
    }

    public synchronized void initialize(Manager manager) {
        if (this.manager != null) {
            throw new IllegalStateException("Callback was already initialized");
        }
        this.manager = manager;
        if (this.registerExisting) {
            for (Simon simon : manager.getSimons(null)) {
                this.register(simon);
            }
        }
    }

    public final void onSimonCreated(Simon simon) {
        if (simon.getName() == null) {
            return;
        }
        this.register(simon);
    }

    public final void onSimonDestroyed(Simon simon) {
        String name = this.constructObjectName(simon);
        this.unregisterSimon(name);
    }

    private synchronized void unregisterSimon(String name) {
        try {
            ObjectName objectName = new ObjectName(name);
            this.mBeanServer.unregisterMBean(objectName);
            this.registeredNames.remove(name);
            this.onManagerMessage("Unregistered Simon with the name: " + objectName);
        }
        catch (JMException e) {
            this.onManagerWarning("JMX unregistration failed for: " + name, e);
        }
    }

    public final void onManagerClear() {
        this.unregisterAllSimons();
    }

    private synchronized void unregisterAllSimons() {
        Iterator<String> namesIter = this.registeredNames.iterator();
        while (namesIter.hasNext()) {
            String name = namesIter.next();
            try {
                ObjectName objectName = new ObjectName(name);
                this.mBeanServer.unregisterMBean(objectName);
                namesIter.remove();
                this.onManagerMessage("Unregistered Simon with the name: " + objectName);
            }
            catch (JMException e) {
                this.onManagerWarning("JMX unregistration failed for: " + name, e);
            }
        }
    }

    public void cleanup() {
        this.unregisterAllSimons();
    }

    protected final void register(Simon simon) {
        SimonSuperMXBean mBean = this.constructObject(simon);
        String name = this.constructObjectName(simon);
        this.registerSimonBean(mBean, name);
    }

    private synchronized void registerSimonBean(Object simonBean, String name) {
        if (simonBean != null && name != null) {
            try {
                ObjectName objectName = new ObjectName(name);
                if (this.mBeanServer.isRegistered(objectName)) {
                    this.mBeanServer.unregisterMBean(objectName);
                } else {
                    this.registeredNames.add(name);
                }
                this.mBeanServer.registerMBean(simonBean, objectName);
                this.onManagerMessage("Simon registered under the name: " + objectName);
            }
            catch (JMException e) {
                this.onManagerWarning("JMX registration failed for: " + name, e);
                this.registeredNames.remove(name);
            }
        }
    }

    protected SimonSuperMXBean constructObject(Simon simon) {
        AbstractSimonMXBeanImpl simonMxBean;
        if (simon instanceof Counter) {
            simonMxBean = new CounterMXBeanImpl((Counter)simon);
        } else if (simon instanceof Stopwatch) {
            simonMxBean = new StopwatchMXBeanImpl((Stopwatch)simon);
        } else {
            this.onManagerWarning("Unknown type of Simon! " + simon, null);
            simonMxBean = null;
        }
        return simonMxBean;
    }

    protected String constructObjectName(Simon simon) {
        return this.domain + ":type=" + this.simonType(simon) + ",name=" + simon.getName();
    }

    protected String simonType(Simon simon) {
        String type = "Unknown";
        if (simon instanceof Counter) {
            type = "Counter";
        } else if (simon instanceof Stopwatch) {
            type = "Stopwatch";
        }
        return type;
    }

    String getDomain() {
        return this.domain;
    }

    MBeanServer getBeanServer() {
        return this.mBeanServer;
    }

    public void setRegisterExisting(boolean registerExisting) {
        this.registerExisting = registerExisting;
    }
}

