/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.Arrays;
import java.util.regex.Pattern;

public final class Replacer {
    private final Pattern from;
    private String to;
    private boolean repeatUntilUnchanged;
    private boolean ignoreCase;
    private Modificator[] modificators;

    public Replacer(String from, String to, Modificator ... modificators) {
        this.processModificators(modificators);
        this.from = this.ignoreCase ? Pattern.compile(from, 2) : Pattern.compile(from);
        this.to = to;
        this.modificators = modificators;
    }

    private void processModificators(Modificator ... modificators) {
        block4: for (Modificator modificator : modificators) {
            switch (modificator) {
                case IGNORE_CASE: {
                    this.ignoreCase = true;
                    continue block4;
                }
                case REPEAT_UNTIL_UNCHANGED: {
                    this.repeatUntilUnchanged = true;
                    continue block4;
                }
            }
        }
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String process(String in) {
        if (this.repeatUntilUnchanged) {
            String retVal = in;
            String old = "";
            while (!old.equals(retVal)) {
                old = retVal;
                retVal = this.from.matcher(retVal).replaceAll(this.to);
            }
            return retVal;
        }
        return this.from.matcher(in).replaceAll(this.to);
    }

    public String toString() {
        return "Replacer{from='" + this.from.pattern() + '\'' + ", to='" + this.to + '\'' + ", mods=" + Arrays.toString((Object[])this.modificators) + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modificator {
        REPEAT_UNTIL_UNCHANGED,
        IGNORE_CASE;

    }
}

