/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.DependencyIgnoredSprintWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

class FixedSlotDependencyViolationDetector {
    FixedSlotDependencyViolationDetector() {
    }

    Set<IScheduleWarning> getDependencyViolations(LinkedHashSet<IEpisodeSchedule> episodeSchedules, IRoadmapProblem problem, @Nullable FixedSlotsAssignmentSolution fixedSprintSolution) {
        if (fixedSprintSolution == null) {
            return Sets.newHashSet();
        }
        HashSet warnings = Sets.newHashSet();
        for (IProcessingItem item : fixedSprintSolution.getProcessingItems()) {
            Optional<IScheduleWarning> warning = this.tryFindWarningForItem(item, episodeSchedules, problem);
            if (!warning.isPresent()) continue;
            warnings.add(warning.get());
        }
        return warnings;
    }

    private Optional<IScheduleWarning> tryFindWarningForItem(IProcessingItem item, LinkedHashSet<IEpisodeSchedule> episodeSchedules, IRoadmapProblem problem) {
        IIntegerInterval itemInterval = (IIntegerInterval)this.getInterval(item, episodeSchedules).get();
        for (IProcessingItem prerequisite : problem.getBacklog().getDependencyDefinition().getDirectPrerequisites(item)) {
            IIntegerInterval prerequisiteInterval = (IIntegerInterval)this.getInterval(prerequisite, episodeSchedules).orNull();
            if (prerequisiteInterval == null || !FixedSlotDependencyViolationDetector.hasIgnoredDependency(itemInterval, prerequisiteInterval, problem.getProcessingDefinition().isSyncDependeeStartEnabled())) continue;
            return Optional.of((Object)new DependencyIgnoredSprintWarning(item.getId()));
        }
        return Optional.absent();
    }

    private Optional<IIntegerInterval> getInterval(IProcessingItem item, LinkedHashSet<IEpisodeSchedule> episodeSchedules) {
        HashSet intervals = Sets.newHashSet();
        for (IEpisodeSchedule schedule : episodeSchedules) {
            Optional<IIntegerInterval> interval = schedule.tryGetInterval(item.getId());
            if (!interval.isPresent()) continue;
            intervals.add(interval.get());
        }
        if (intervals.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)RmUtils.getMergedIntervals(intervals));
    }

    private static boolean hasIgnoredDependency(IIntegerInterval itemInterval, IIntegerInterval prerequisiteInterval, boolean syncStartEnabled) {
        if (itemInterval.getLength() == 0 || prerequisiteInterval.getLength() == 0) {
            return false;
        }
        if (syncStartEnabled) {
            return itemInterval.getStart() < prerequisiteInterval.getStart();
        }
        return itemInterval.getStart() <= prerequisiteInterval.getEnd();
    }
}

