/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.base.Preconditions;

public class TeamVelocitySupplyWrapper
implements IWorkSlotFunction {
    private final ITeamVelocityFunction teamVelocity;
    private final WorkSlotsDefinition workSlotsDefinition;

    public TeamVelocitySupplyWrapper(ITeamVelocityFunction teamVelocity, WorkSlotsDefinition workSlotsDefinition) {
        this.teamVelocity = (ITeamVelocityFunction)Preconditions.checkNotNull((Object)teamVelocity);
        this.workSlotsDefinition = (WorkSlotsDefinition)Preconditions.checkNotNull((Object)workSlotsDefinition);
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        if (this.workSlotsDefinition.isRestrictedWorkSlot(slotIndex)) {
            return 0.0f;
        }
        return this.getRestrictedAvailability(slotIndex);
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        return this.teamVelocity.getVelocity(slotIndex);
    }

    @Override
    public int getFirstRegularTimeStep() {
        return 0;
    }

    @Override
    public boolean isPositiveEnding() {
        return this.teamVelocity.isPositiveEnding();
    }
}

