/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.estimates;

import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.services.workitems.estimates.WorkItemEstimateServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
public abstract class CommonWorkItemEstimateService {
    private final DataMode dataMode;
    protected final WorkItemEstimateServiceHandler handler;

    protected CommonWorkItemEstimateService(DataMode dataMode, SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence, PortfolioPlanPersistence planPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this.dataMode = dataMode;
        this.handler = handlerFactory.createProxy(WorkItemEstimateServiceHandler.class, new WorkItemEstimateServiceHandler.Impl(estimatePersistence, stagePersistence, skillPersistence, workItemPersistence, planPersistence, portfolioToJiraSyncExtension), workItemPersistence);
    }

    @PUT
    @Path(value="/skill/{skillId}")
    public Response setSkillEstimate(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, @PathParam(value="skillId") String skillId, RestEstimate estimate) throws Exception {
        return this.handler.setSkillEstimate(EntityContext.from(id, expectedPlanVersion, clientId), skillId, estimate, this.dataMode);
    }

    @PUT
    @Path(value="/stage/{stageId}")
    public Response setStageEstimate(@PathParam(value="id") String id, @PathParam(value="stageId") String stageId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestEstimate estimate) throws Exception {
        return this.handler.setStageEstimate(EntityContext.from(id, expectedPlanVersion, clientId), stageId, estimate, this.dataMode);
    }

    @PUT
    @Path(value="/total")
    public Response setTotalEstimate(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestEstimate estimate) throws Exception {
        return this.handler.setTotalEstimate(EntityContext.from(id, expectedPlanVersion, clientId), estimate, this.dataMode);
    }
}

