/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.BatchRankChange;
import com.atlassian.greenhopper.service.rank.JpoRankService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankOperationResponse;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.InternalAgileRankService")
class InternalAgileRankService {
    private static final String RANK_SERVICE_ID = "jpoRankServiceImpl";
    private static final Log LOGGER = Log.with(InternalAgileRankService.class);
    private final BundleServiceAccessorProvider bundleServiceAccessorProvider;
    private final JiraAuthenticationContext authenticationContext;
    private final DummyApplicationUser dummyApplicationUser = new DummyApplicationUser();

    @Autowired
    InternalAgileRankService(BundleServiceAccessorProvider bundleServiceAccessorProvider, JiraAuthenticationContext authenticationContext) {
        this.bundleServiceAccessorProvider = bundleServiceAccessorProvider;
        this.authenticationContext = authenticationContext;
    }

    AgileRankOperationResponse rankFirst(final List<Long> ids, final long domain) throws Exception {
        LOGGER.debug("rank first request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome<BatchRankChange> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<BatchRankChange>>(){

            @Override
            public ServiceOutcome<BatchRankChange> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.rankFirst(ids, domain, InternalAgileRankService.this.authenticationContext.getUser());
            }
        });
        return AgileRankOperationResponse.create(outcome, ids);
    }

    AgileRankOperationResponse rankLast(final List<Long> ids, final long domain) throws Exception {
        LOGGER.debug("rank last request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome<BatchRankChange> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<BatchRankChange>>(){

            @Override
            public ServiceOutcome<BatchRankChange> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.rankLast(ids, domain, InternalAgileRankService.this.authenticationContext.getUser());
            }
        });
        return AgileRankOperationResponse.create(outcome, ids);
    }

    AgileRankOperationResponse rankBefore(final List<Long> ids, final long anchorId, final long domain) throws Exception {
        LOGGER.debug("rank before anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome<BatchRankChange> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<BatchRankChange>>(){

            @Override
            public ServiceOutcome<BatchRankChange> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.rankBefore(ids, anchorId, domain, InternalAgileRankService.this.authenticationContext.getUser());
            }
        });
        return AgileRankOperationResponse.create(outcome, ids);
    }

    AgileRankOperationResponse rankAfter(final List<Long> ids, final long anchorId, final long domain) throws Exception {
        LOGGER.debug("rank after anchor %d request for domain %d: %s", anchorId, domain, Joiner.on((String)",").join(ids));
        ServiceOutcome<BatchRankChange> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<BatchRankChange>>(){

            @Override
            public ServiceOutcome<BatchRankChange> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.rankAfter(ids, anchorId, domain, InternalAgileRankService.this.authenticationContext.getUser());
            }
        });
        return AgileRankOperationResponse.create(outcome, ids);
    }

    ImmutableMap<Long, String> getRankValues(final Collection<Long> ids, final long domain) throws Exception {
        LOGGER.debug("rank value request for domain %d: %s", domain, Joiner.on((String)",").join(ids));
        ServiceOutcome<Map<Long, String>> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<Map<Long, String>>>(){

            @Override
            public ServiceOutcome<Map<Long, String>> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.getLexoRankValues(ids, domain, (ApplicationUser)InternalAgileRankService.this.dummyApplicationUser);
            }
        });
        InternalAgileRankService.logErrors(outcome.getErrors().getErrors());
        return ImmutableMap.copyOf((Map)((Map)outcome.get()));
    }

    ImmutableList<Long> sort(final Collection<Long> ids, final long domain) throws Exception {
        ServiceOutcome<List<Long>> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<List<Long>>>(){

            @Override
            public ServiceOutcome<List<Long>> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.sort(ids, domain, (ApplicationUser)InternalAgileRankService.this.dummyApplicationUser);
            }
        });
        InternalAgileRankService.logErrors(outcome.getErrors().getErrors());
        return ImmutableList.copyOf((Collection)((Collection)outcome.get()));
    }

    public void delete(final Long id) throws Exception {
        ServiceOutcome<Void> outcome = this.getServiceAccessor().perform(new ServiceCallback<JpoRankService, ServiceOutcome<Void>>(){

            @Override
            public ServiceOutcome<Void> perform(JpoRankService jpoRankService) throws Exception {
                return jpoRankService.deleteIds((Iterable)Lists.newArrayList((Object[])new Long[]{id}), InternalAgileRankService.this.authenticationContext.getUser());
            }
        });
        InternalAgileRankService.logErrors(outcome.getErrors().getErrors());
    }

    private static void logErrors(Collection<ErrorCollection.ErrorItem> errors) {
        if (errors != null && !errors.isEmpty()) {
            LOGGER.error("Agile call returned errors: %s", Joiner.on((String)",").join(errors));
        }
    }

    private BundleServiceAccessor<JpoRankService> getServiceAccessor() {
        return this.bundleServiceAccessorProvider.createUnsafeServiceAccessor("com.pyxis.greenhopper.jira", RANK_SERVICE_ID);
    }

    private static class DummyApplicationUser
    implements ApplicationUser {
        private DummyApplicationUser() {
        }

        public String getKey() {
            return null;
        }

        public String getUsername() {
            return null;
        }

        public String getName() {
            return null;
        }

        public long getDirectoryId() {
            return 0L;
        }

        public boolean isActive() {
            return false;
        }

        public String getEmailAddress() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public User getDirectoryUser() {
            return null;
        }

        public Long getId() {
            return null;
        }
    }
}

