/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api.plugins;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.rm.common.bridges.api.Version;
import com.google.common.base.Optional;
import javax.annotation.Nullable;

public class PluginAvailabilityChecker {
    private final String pluginKey;
    private final Optional<Version> minimumVersion;
    private final PluginAccessor pluginAccessor;

    public PluginAvailabilityChecker(String pluginKey, Optional<Version> minimumVersion, PluginAccessor pluginAccessor) {
        this.pluginKey = pluginKey;
        this.minimumVersion = minimumVersion;
        this.pluginAccessor = pluginAccessor;
    }

    public String getVersion() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            return plugin.getPluginInformation().getVersion();
        }
        return null;
    }

    public boolean isInstalled() {
        String versionString = this.getVersion();
        return versionString != null;
    }

    public boolean hasMinimumVersion() {
        String versionString = this.getVersion();
        if (versionString != null) {
            return this.isMinimumVersion(versionString);
        }
        return false;
    }

    public boolean isEnabled() {
        return this.pluginAccessor.isPluginEnabled(this.pluginKey);
    }

    public boolean isAvailable() {
        return this.hasMinimumVersion() && this.isEnabled();
    }

    @Nullable
    public String getVersionIfAvailable() {
        String versionString = this.getVersion();
        if (versionString != null && this.isMinimumVersion(versionString) && this.isEnabled()) {
            return versionString;
        }
        return null;
    }

    private boolean isMinimumVersion(String versionString) {
        if (this.minimumVersion.isPresent()) {
            return new Version(versionString).compareTo((Version)this.minimumVersion.get()) >= 0;
        }
        return true;
    }

    private Plugin getPlugin() {
        return this.pluginAccessor.getPlugin(this.pluginKey);
    }
}

