/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.LicenseErrorType;
import com.atlassian.rm.common.bridges.jira.license.PluginLicenseServiceBridge;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.license.PluginLicenseServiceBridgeImpl")
@SupportedVersions(all=true)
class PluginLicenseServiceBridgeImpl
implements PluginLicenseServiceBridge {
    @ComponentImport
    @Autowired(required=false)
    @VisibleForTesting
    PluginLicenseManager licenseManager;

    @Override
    public LicenseData getLicenseData(boolean hasValidDCProductLicense, boolean isDCBundlingEnabled) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                LicenseErrorType licenseErrorType;
                String details;
                LicenseError licenseError = (LicenseError)license.getError().get();
                if (licenseError == LicenseError.EXPIRED && !license.isEvaluation() && license.getLicenseType() != LicenseType.TESTING) {
                    return LicenseData.createValid();
                }
                switch (licenseError) {
                    case EXPIRED: {
                        details = PluginLicenseServiceBridgeImpl.getLicenseErrorDetails(license, "Your license for Portfolio for Jira has expired.");
                        licenseErrorType = LicenseErrorType.Expired;
                        break;
                    }
                    case TYPE_MISMATCH: {
                        details = PluginLicenseServiceBridgeImpl.getLicenseErrorDetails(license, "Invalid license: Your license for Portfolio for Jira does not match the license type on this Jira installation.");
                        licenseErrorType = LicenseErrorType.TypeMismatch;
                        break;
                    }
                    case USER_MISMATCH: {
                        details = PluginLicenseServiceBridgeImpl.getLicenseErrorDetails(license, "Portfolio for Jira is only licensed for a limited number of users that has been exceeded.");
                        licenseErrorType = LicenseErrorType.UserMismatch;
                        break;
                    }
                    case VERSION_MISMATCH: {
                        details = PluginLicenseServiceBridgeImpl.getLicenseErrorDetails(license, "Your license for maintenance of Portfolio for Jira is not valid for the installed version.");
                        licenseErrorType = LicenseErrorType.VersionMismatch;
                        break;
                    }
                    default: {
                        details = "No detail information available.";
                        licenseErrorType = LicenseErrorType.Unlicensed;
                    }
                }
                return LicenseData.createInvalid(licenseError.name(), licenseErrorType, details);
            }
            if (isDCBundlingEnabled && license.isDataCenter() && !hasValidDCProductLicense) {
                return LicenseData.createInvalid(LicenseError.TYPE_MISMATCH.name(), LicenseErrorType.TypeMismatch, PluginLicenseServiceBridgeImpl.getLicenseErrorDetails(license, "Invalid license: Your license for Portfolio for Jira does not match the license type on this Jira installation."));
            }
            return LicenseData.createValid();
        }
        return LicenseData.createInvalid("Portfolio for Jira is not licensed.", LicenseErrorType.Unlicensed, "Please purchase a license or get an evaluation license if you want to use Portfolio for Jira.");
    }

    private static String getLicenseErrorDetails(PluginLicense license, String customMessage) {
        StringBuilder retVal = new StringBuilder();
        retVal.append(customMessage + "\n");
        retVal.append("\tLicense version: " + (license.getLicenseVersion().isDefined() ? (Serializable)license.getLicenseVersion().get() : "Unknown") + "\n");
        retVal.append("\tLicense violation: " + (license.getError().isDefined() ? ((LicenseError)license.getError().get()).name() : "Unknown") + "\n");
        retVal.append("\tLicense type: " + license.getLicenseType().name() + (license.isEvaluation() ? " (EVALUATION)" : " (STANDARD)") + "\n");
        retVal.append("\tMax. users: " + (license.getMaximumNumberOfUsers().isDefined() ? (Serializable)license.getMaximumNumberOfUsers().get() : "Unknown") + "\n");
        retVal.append("\tExpiry date: " + (license.getExpiryDate().isDefined() ? (Serializable)license.getExpiryDate().get() : "Unknown") + "\n");
        retVal.append("\tMaintenance expiry date: " + (license.getMaintenanceExpiryDate().isDefined() ? (Serializable)license.getMaintenanceExpiryDate().get() : "Unknown") + "\n");
        return retVal.toString();
    }
}

