/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.DatabaseSchemaCreation;
import com.atlassian.rm.common.pkqdsl.legacy.MemoizingResettingReference;
import com.atlassian.rm.common.pkqdsl.legacy.Unit;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import org.joor.Reflect;
import org.joor.ReflectException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.pkqdsl.legacy.DatabaseSchemaCreationImpl")
public class DatabaseSchemaCreationImpl
implements DatabaseSchemaCreation {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSchemaCreationImpl.class);
    private static final String AO_SERVICE_NAME = "com.atlassian.activeobjects.external.ActiveObjects";
    private final MemoizingResettingReference<Unit, Unit> initialised;
    private final BundleContext bundleContext;

    @Autowired
    public DatabaseSchemaCreationImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initialised = new MemoizingResettingReference<Unit, Unit>(this.primeImpl());
    }

    @Override
    public void prime() {
        this.initialised.get(Unit.VALUE);
    }

    private Function<Unit, Unit> primeImpl() {
        return new Function<Unit, Unit>(){

            public Unit apply(Unit input) {
                Optional service = DatabaseSchemaCreationImpl.this.getService(DatabaseSchemaCreationImpl.AO_SERVICE_NAME);
                if (service.isPresent()) {
                    DatabaseSchemaCreationImpl.this.invokeAo(service.get());
                }
                return Unit.VALUE;
            }
        };
    }

    private Optional<Object> getService(String serviceName) {
        Optional sRef = Optional.fromNullable((Object)this.bundleContext.getServiceReference(serviceName));
        if (sRef.isPresent()) {
            return Optional.fromNullable((Object)this.bundleContext.getService((ServiceReference)sRef.get()));
        }
        return Optional.absent();
    }

    private void invokeAo(Object ao) {
        try {
            log.debug("ActiveObjects found - invoking via reflection....");
            Reflect.on(ao).call("flushAll");
        }
        catch (ReflectException e) {
            log.warn("ActiveObjects method flushAll is not available : " + e.toString());
        }
    }
}

