/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IPartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IUnstructuredStageLpProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.LpSolutionToAssignmentCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache.ApacheUnstructuredStageSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.UnstructuredStageLpProblemCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractSlotAssignmentCreator {
    private static final Log LOGGER = Log.with(AbstractSlotAssignmentCreator.class);
    private final LpSolutionToAssignmentCreator assignmentCreator = new LpSolutionToAssignmentCreator();
    private final IUnstructuredStageLpProblemCreator unstructuredStageLpProblemCreator = new UnstructuredStageLpProblemCreator();
    private final IUnstructuredStageLpProblemSolver unstructuredStageLpSolver;

    AbstractSlotAssignmentCreator(CancellationState cancellationState) {
        this.unstructuredStageLpSolver = new ApacheUnstructuredStageSolver(cancellationState);
    }

    public Optional<ISingleResourceGroupAssignment> tryCreateAssignment(IPartialUnstructuredItemStageProblem stageProblem, IMutableResourcePool resourcePool, int upperTimeBound) throws InterruptedException {
        int releaseTime = stageProblem.getLowerTimeBound();
        IWorkSlot nextSlot = resourcePool.getNextValidWorkSlotForReleaseTime(releaseTime);
        MutablePositivePrimitivesMap<IMutableResource> availableWorkSum = RmCollectionUtils.newMutablePositiveMap(resourcePool.getMutableResources().size());
        List<Object> slots = Lists.newArrayList();
        IWorkSlot testSlot = resourcePool.getEarliestConstantSlotWithoutAssignment(nextSlot.getIndex());
        boolean tested = false;
        while ((slots = this.getNextSlots(nextSlot, upperTimeBound, slots)) != null) {
            Optional<ISingleResourceGroupAssignment> assignment;
            Optional<IUnstructuredStageLpProblem> problem;
            MutablePositivePrimitivesMap<IMutableResource> newAvailableWork = resourcePool.getSchedulableWorkInTimeSlot(nextSlot.getIndex());
            nextSlot = resourcePool.getNextWorkSlot(nextSlot);
            availableWorkSum.add(newAvailableWork);
            if (!tested && testSlot.getEnd() < nextSlot.getStart() && !resourcePool.isFinishableWithoutTimeLimit(stageProblem.getPositiveTypeAmounts(), newAvailableWork)) {
                problem = this.tryCreateProblem(stageProblem, availableWorkSum, slots, newAvailableWork);
                return this.trySolve((IUnstructuredStageLpProblem)problem.orNull(), slots, resourcePool);
            }
            tested = true;
            if (newAvailableWork.isEmpty() || !(assignment = this.trySolve((IUnstructuredStageLpProblem)(problem = this.tryCreateProblem(stageProblem, availableWorkSum, slots, newAvailableWork)).orNull(), slots, resourcePool)).isPresent()) continue;
            LogUtil.debug(LOGGER, "found assignment: %s", assignment.get());
            return assignment;
        }
        LogUtil.debug(LOGGER, "could not find assignment");
        return Optional.absent();
    }

    private Optional<ISingleResourceGroupAssignment> trySolve(@Nullable IUnstructuredStageLpProblem problem, List<IWorkSlot> slots, IMutableResourcePool resourcePool) throws InterruptedException {
        Optional<float[]> lpSolution;
        if (problem != null && (lpSolution = this.unstructuredStageLpSolver.trySolve(problem)).isPresent()) {
            return this.assignmentCreator.tryCreateAssignment((float[])lpSolution.get(), problem, slots, resourcePool.getMutableResourceGroup().getDefinition());
        }
        return Optional.absent();
    }

    private Optional<IUnstructuredStageLpProblem> tryCreateProblem(IPartialUnstructuredItemStageProblem stageProblem, PositivePrimitivesMap<IMutableResource> availableWorkSum, List<IWorkSlot> slots, PositivePrimitivesMap<IMutableResource> newAvailableWork) {
        if (slots.size() == 1) {
            return this.unstructuredStageLpProblemCreator.tryCreateInstance(stageProblem, newAvailableWork);
        }
        return this.unstructuredStageLpProblemCreator.tryCreateInstance(stageProblem, availableWorkSum);
    }

    abstract List<IWorkSlot> getNextSlots(IWorkSlot var1, int var2, List<IWorkSlot> var3);
}

