/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IResourceToTypeWeightVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IResourceToTypeAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.SingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.WorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.VariableAvailabilityState;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class LpSolutionToAssignmentCreator {
    private static final Log LOGGER = Log.with(LpSolutionToAssignmentCreator.class);

    LpSolutionToAssignmentCreator() {
    }

    Optional<ISingleResourceGroupAssignment> tryCreateAssignment(float[] lpSolution, IResourceToTypeAssignmentProblem problem, List<IWorkSlot> workSlots, IResourceGroup resourceGroup) {
        Set<IWorkAssignment> workAssignments = this.createWorkAssignments(lpSolution, problem, workSlots, resourceGroup);
        return SingleResourceGroupAssignment.tryCreateInstance(workAssignments);
    }

    Set<IWorkAssignment> createWorkAssignments(float[] lpSolution, IResourceToTypeAssignmentProblem problem, List<IWorkSlot> workSlots, IResourceGroup resourceGroup) {
        LogUtil.debug(LOGGER, "create assigment map for point: %s", Arrays.toString(lpSolution));
        HashSet workAssignments = Sets.newHashSet();
        Set<IMutableResource> resources = problem.getWorkResourceLimits().keySet();
        for (IMutableResource resource : resources) {
            VariableAvailabilityState availabilityState = VariableAvailabilityState.init(workSlots, resource);
            Set<Integer> indicesForWorkResource = problem.getIndicesForWorkResource(resource);
            if (indicesForWorkResource == null) continue;
            block1: for (int variableIndex : indicesForWorkResource) {
                float workLoad = lpSolution[variableIndex];
                if (workLoad < 0.01f) continue;
                IResourceToTypeWeightVariable variable = problem.getAssignmentVariable(variableIndex);
                IResourceType type = variable.getResourceType();
                for (IWorkSlot slot : workSlots) {
                    float available = availabilityState.getAvailability(slot.getIndex());
                    float assignedWorkUnits = Math.min(available, workLoad);
                    if (assignedWorkUnits < 0.01f) continue;
                    availabilityState.reduce(slot.getIndex(), assignedWorkUnits);
                    WorkAssignment workAssignment = new WorkAssignment(problem.getId(), slot, variable.getProcessingStage(), resourceGroup, resource, type, assignedWorkUnits, problem.getProjectEpisode());
                    workAssignments.add(workAssignment);
                    if (!((workLoad -= assignedWorkUnits) <= 0.0f)) continue;
                    continue block1;
                }
            }
        }
        return workAssignments;
    }
}

