/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.SearchCancellationTest;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.search.SearchState;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DefaultStateTransition {
    private final int upperBound;
    private final SearchCancellationTest searchCancellationTest;

    DefaultStateTransition(int upperBound, SearchCancellationTest searchCancellationTest) {
        this.upperBound = upperBound;
        this.searchCancellationTest = searchCancellationTest;
    }

    public Optional<SearchState<AssignmentCandidate>> getNextState(SearchState<AssignmentCandidate> state) throws InterruptedException {
        AssignmentCandidate candidate = state.getCandidate();
        if (candidate.getLatestTime() >= this.upperBound) {
            return Optional.absent();
        }
        if (this.searchCancellationTest.isToCancel(candidate)) {
            return Optional.absent();
        }
        if (this.useMultiSlot(candidate)) {
            return Optional.of(state.createAddTime());
        }
        return Optional.of(state.createNextTime());
    }

    private boolean useMultiSlot(AssignmentCandidate candidate) {
        if (candidate.getTimeIndices().size() > 1) {
            return true;
        }
        if (candidate.isNoOneAvailable()) {
            return false;
        }
        if (candidate.isSyncStart() && candidate.isEveryoneAvailableFree()) {
            return true;
        }
        return !candidate.isSyncStart() && candidate.isSomeoneAvailableFree();
    }

    public static DefaultStateTransition createInstance(BoundAssignmentProblem problem) {
        return new DefaultStateTransition(problem.getTimeInterval().getEnd(), new SearchCancellationTest());
    }
}

