/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import java.util.Arrays;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class LpLogging {
    private static final String UNKNOWN = "?";
    private static final Log LOGGER = Log.with(LpLogging.class);

    public static void logDebug(OptimizationData ... data) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("logging LP", new Object[0]);
            LOGGER.debug(LpLogging.createLogString(data), new Object[0]);
        }
    }

    public static String createLogString(OptimizationData[] data) {
        StringBuilder logString = new StringBuilder();
        logString.append(LpLogging.getGoalTypeString(LpLogging.getGoalType(data)));
        logString.append(LpLogging.getObjectiveString(LpLogging.getLinearObjectiveFunction(data))).append("\n");
        logString.append(LpLogging.getLinearConstraintsString(LpLogging.getLinearConstraints(data))).append("\n");
        logString.append(LpLogging.getNonNegativeString(LpLogging.getNonNegativity(data)));
        return logString.toString();
    }

    private static String getNonNegativeString(Optional<NonNegativeConstraint> nonNegativity) {
        if (nonNegativity.isPresent()) {
            return "NonNegative " + ((NonNegativeConstraint)nonNegativity.get()).isRestrictedToNonNegative();
        }
        return UNKNOWN;
    }

    private static Optional<NonNegativeConstraint> getNonNegativity(OptimizationData[] data) {
        for (OptimizationData optimizationData : data) {
            if (!(optimizationData instanceof NonNegativeConstraint)) continue;
            return Optional.of((Object)((NonNegativeConstraint)optimizationData));
        }
        return Optional.absent();
    }

    private static String getLinearConstraintsString(Optional<LinearConstraintSet> linearConstraints) {
        if (linearConstraints.isPresent()) {
            StringBuilder string = new StringBuilder();
            for (LinearConstraint linearConstraint : ((LinearConstraintSet)linearConstraints.get()).getConstraints()) {
                string.append(Arrays.toString(linearConstraint.getCoefficients().toArray())).append((Object)linearConstraint.getRelationship()).append(linearConstraint.getValue()).append("\n");
            }
            return string.toString();
        }
        return UNKNOWN;
    }

    private static Optional<LinearConstraintSet> getLinearConstraints(OptimizationData ... data) {
        for (OptimizationData optimizationData : data) {
            if (!(optimizationData instanceof LinearConstraintSet)) continue;
            return Optional.of((Object)((LinearConstraintSet)optimizationData));
        }
        return Optional.absent();
    }

    private static String getObjectiveString(Optional<LinearObjectiveFunction> linearObjectiveFunction) {
        if (linearObjectiveFunction.isPresent()) {
            return Arrays.toString(((LinearObjectiveFunction)linearObjectiveFunction.get()).getCoefficients().toArray()) + ((LinearObjectiveFunction)linearObjectiveFunction.get()).getConstantTerm();
        }
        return UNKNOWN;
    }

    private static Optional<LinearObjectiveFunction> getLinearObjectiveFunction(OptimizationData ... data) {
        for (OptimizationData optimizationData : data) {
            if (!(optimizationData instanceof LinearObjectiveFunction)) continue;
            return Optional.of((Object)((LinearObjectiveFunction)optimizationData));
        }
        return Optional.absent();
    }

    private static String getGoalTypeString(Optional<GoalType> goalType) {
        if (goalType.isPresent()) {
            if (((GoalType)goalType.get()).equals(GoalType.MAXIMIZE)) {
                return "MAX";
            }
            return "MIN";
        }
        return UNKNOWN;
    }

    private static Optional<GoalType> getGoalType(OptimizationData ... data) {
        for (OptimizationData optimizationData : data) {
            if (!(optimizationData instanceof GoalType)) continue;
            return Optional.of((Object)((GoalType)optimizationData));
        }
        return Optional.absent();
    }
}

