/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.TemporalExpression;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class DateTimeExpression<T extends Comparable>
extends TemporalExpression<T> {
    private static final DateTimeExpression<Date> CURRENT_DATE = DateTimeExpression.currentDate(Date.class);
    private static final DateTimeExpression<Date> CURRENT_TIMESTAMP = DateTimeExpression.currentTimestamp(Date.class);
    private static final long serialVersionUID = -6879277113694148047L;
    @Nullable
    private volatile NumberExpression<Integer> dayOfMonth;
    @Nullable
    private volatile NumberExpression<Integer> dayOfWeek;
    @Nullable
    private volatile NumberExpression<Integer> dayOfYear;
    @Nullable
    private volatile NumberExpression<Integer> hours;
    @Nullable
    private volatile NumberExpression<Integer> minutes;
    @Nullable
    private volatile NumberExpression<Integer> seconds;
    @Nullable
    private volatile NumberExpression<Integer> milliseconds;
    @Nullable
    private volatile DateTimeExpression<T> min;
    @Nullable
    private volatile DateTimeExpression<T> max;
    @Nullable
    private volatile NumberExpression<Integer> week;
    @Nullable
    private volatile NumberExpression<Integer> month;
    @Nullable
    private volatile NumberExpression<Integer> year;
    @Nullable
    private volatile NumberExpression<Integer> yearMonth;
    @Nullable
    private volatile NumberExpression<Integer> yearWeek;

    public static DateTimeExpression<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> DateTimeExpression<T> currentDate(Class<T> cl) {
        return DateTimeOperation.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expression[0]);
    }

    public static DateTimeExpression<Date> currentTimestamp() {
        return CURRENT_TIMESTAMP;
    }

    public static <T extends Comparable> DateTimeExpression<T> currentTimestamp(Class<T> cl) {
        return DateTimeOperation.create(cl, Ops.DateTimeOps.CURRENT_TIMESTAMP, new Expression[0]);
    }

    public DateTimeExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public DateTimeExpression<T> as(Path<T> alias) {
        return DateTimeOperation.create(this.getType(), Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public DateTimeExpression<T> as(String alias) {
        return this.as((Path)new PathImpl(this.getType(), alias));
    }

    public NumberExpression<Integer> dayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this.mixin);
        }
        return this.dayOfMonth;
    }

    public NumberExpression<Integer> dayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this.mixin);
        }
        return this.dayOfWeek;
    }

    public NumberExpression<Integer> dayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this.mixin);
        }
        return this.dayOfYear;
    }

    public NumberExpression<Integer> hour() {
        if (this.hours == null) {
            this.hours = NumberOperation.create(Integer.class, Ops.DateTimeOps.HOUR, this.mixin);
        }
        return this.hours;
    }

    public DateTimeExpression<T> max() {
        if (this.max == null) {
            this.max = DateTimeOperation.create(this.getType(), Ops.AggOps.MAX_AGG, this.mixin);
        }
        return this.max;
    }

    public NumberExpression<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = NumberOperation.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this.mixin);
        }
        return this.milliseconds;
    }

    public DateTimeExpression<T> min() {
        if (this.min == null) {
            this.min = DateTimeOperation.create(this.getType(), Ops.AggOps.MIN_AGG, this.mixin);
        }
        return this.min;
    }

    public NumberExpression<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = NumberOperation.create(Integer.class, Ops.DateTimeOps.MINUTE, this.mixin);
        }
        return this.minutes;
    }

    public NumberExpression<Integer> month() {
        if (this.month == null) {
            this.month = NumberOperation.create(Integer.class, Ops.DateTimeOps.MONTH, this.mixin);
        }
        return this.month;
    }

    public NumberExpression<Integer> second() {
        if (this.seconds == null) {
            this.seconds = NumberOperation.create(Integer.class, Ops.DateTimeOps.SECOND, this.mixin);
        }
        return this.seconds;
    }

    public NumberExpression<Integer> week() {
        if (this.week == null) {
            this.week = NumberOperation.create(Integer.class, Ops.DateTimeOps.WEEK, this.mixin);
        }
        return this.week;
    }

    public NumberExpression<Integer> year() {
        if (this.year == null) {
            this.year = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR, this.mixin);
        }
        return this.year;
    }

    public NumberExpression<Integer> yearMonth() {
        if (this.yearMonth == null) {
            this.yearMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR_MONTH, this.mixin);
        }
        return this.yearMonth;
    }

    public NumberExpression<Integer> yearWeek() {
        if (this.yearWeek == null) {
            this.yearWeek = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR_WEEK, this.mixin);
        }
        return this.yearWeek;
    }
}

