/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.AOExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.extensions.sql.ExtensionLinkSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.ReleaseQueryResult;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql.ReleaseQueryResultImpl;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import com.radiantminds.roadmap.common.rest.entities.releases.RestStream;
import com.radiantminds.roadmap.common.rest.entities.releases.links.RestReleaseExtensionLinkResponse;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ReleaseSQL
extends BaseAOPersistenceSQL {
    private final ExtensionLinkSQL extensionLinkSQL;

    public ReleaseSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.extensionLinkSQL = new ExtensionLinkSQL(activeObjectsUtilities);
    }

    public List<IRelease> getReleases(final String streamId, final boolean includeLater) throws SQLException {
        return this.sql(new IQuery<List<IRelease>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AORelease.class, "r").select();
                ReleaseSQL.addReleaseSelect(generator, "r");
                generator.from("r").where().col("r", "aostream").eq().numeric(streamId);
                if (!includeLater) {
                    generator.and().col("r", "islater").isNull().or().col("r", "islater").eq().bool(false);
                }
                generator.orderBy().col("r", "sortOrder");
            }

            @Override
            public List<IRelease> handleResult(ResultSet result) throws Exception {
                ArrayList releases = Lists.newArrayList();
                while (result.next()) {
                    RestRelease release = ReleaseSQL.this.parseRelease(result, 0);
                    release.setIsLaterRelease(false);
                    releases.add(release);
                }
                return releases;
            }
        });
    }

    public IRelease getLaterRelease(final String streamId) throws SQLException {
        return this.sql(new IQuery<IRelease>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AORelease.class, "r").select();
                ReleaseSQL.addReleaseSelect(generator, "r");
                generator.from("r").where().col("r", "aoStream").eq().numeric(streamId).and().col("r", "islater").eq().bool(true);
            }

            @Override
            public IRelease handleResult(ResultSet result) throws Exception {
                RestRelease release = null;
                if (result.next()) {
                    release = ReleaseSQL.this.parseRelease(result, 0);
                    release.setIsLaterRelease(true);
                }
                return release;
            }
        });
    }

    public static void addReleaseSelect(AOQueryGenerator generator, String tableKey) {
        generator.colId(tableKey).col(tableKey, "version").col(tableKey, "title").col(tableKey, "primaryVersion").col(tableKey, "details").col(tableKey, "aOFixedStartDate").col(tableKey, "aODeltaStartDate").col(tableKey, "aOFixedEndDate").col(tableKey, "sortOrder").col(tableKey, "isLaterRelease");
    }

    public RestRelease parseRelease(ResultSet result, int offset) throws SQLException {
        String id = ReleaseSQL.getString(result, 1 + offset);
        Long version = ReleaseSQL.getLong(result, 2 + offset);
        String title = ReleaseSQL.getString(result, 3 + offset);
        String primaryVersion = ReleaseSQL.getString(result, 4 + offset);
        String description = ReleaseSQL.getString(result, 5 + offset);
        Long fixedStartDate = ReleaseSQL.getLong(result, 6 + offset);
        Long deltaStartDate = ReleaseSQL.getLong(result, 7 + offset);
        Long fixedEndDate = ReleaseSQL.getLong(result, 8 + offset);
        Long sortOrder = ReleaseSQL.getLong(result, 9 + offset);
        Boolean isLater = ReleaseSQL.getBoolean(result, 10 + offset);
        RestRelease release = new RestRelease(id, title, description, fixedEndDate, fixedStartDate, deltaStartDate, primaryVersion);
        release.setVersion(version);
        release.setSortOrder(sortOrder);
        release.setIsLaterRelease(isLater);
        this.extensionLinkSQL.getTargetIdsForLink(IRelease.class, id, id);
        return release;
    }

    public ReleaseQueryResult getReleasesWithDetails(final Collection<String> releaseIds) throws SQLException {
        if (releaseIds == null || releaseIds.size() <= 0) {
            return ReleaseQueryResultImpl.EMPTY;
        }
        return this.sql(new IQuery<ReleaseQueryResult>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AORelease.class, "r").withTable(AOStream.class, "s").withTable(AOExtensionLink.class, "x").select();
                ReleaseSQL.addReleaseSelect(generator, "r");
                generator.col("x", "extensionKey").col("x", "extensionLink").colId("s").col("s", "title").col("s", "shortName").from("r").leftJoin().table("s").on().col("r", "aoStream").eq().colId("s").leftJoin().table("x").on().colPolyType("x", "aoExtendable").eq().str(AORelease.class.getName()).and().col("x", "aoExtendable").eq().colId("r").where().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId("r");
                    }
                }, releaseIds);
            }

            @Override
            public ReleaseQueryResult handleResult(ResultSet result) throws Exception {
                HashMap releasesMap = Maps.newHashMap();
                HashMap streamsMap = Maps.newHashMap();
                HashMap releaseToStreamMap = Maps.newHashMap();
                while (result.next()) {
                    String streamId;
                    String releaseId = BaseAOPersistenceSQL.getString(result, 1);
                    if (!releasesMap.containsKey(releaseId)) {
                        releasesMap.put(releaseId, ReleaseSQL.this.parseRelease(result, 0));
                    }
                    RestRelease release = (RestRelease)releasesMap.get(releaseId);
                    String extensionKey = BaseAOPersistenceSQL.getString(result, 11);
                    String extensionLink = BaseAOPersistenceSQL.getString(result, 12);
                    if (extensionKey != null && extensionLink != null) {
                        release.addExtensionLink(new RestReleaseExtensionLinkResponse(extensionKey, extensionLink));
                    }
                    if (!streamsMap.containsKey(streamId = BaseAOPersistenceSQL.getString(result, 13))) {
                        String streamTitle = BaseAOPersistenceSQL.getString(result, 14);
                        String streamShortName = BaseAOPersistenceSQL.getString(result, 15);
                        RestStream stream = new RestStream(streamId, streamTitle, null);
                        stream.setShortName(streamShortName);
                        streamsMap.put(streamId, stream);
                    }
                    if (releaseToStreamMap.containsKey(releaseId)) continue;
                    releaseToStreamMap.put(releaseId, streamId);
                }
                return new ReleaseQueryResultImpl(releasesMap, streamsMap, releaseToStreamMap);
            }
        });
    }
}

