/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.skills;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.sql.StageSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsStagePersistence
extends AOSortableEntityPersistence<IStage, AOStage>
implements PortfolioStagePersistence {
    private final EntityInfoSQL entityInfoSQL;
    private final StageSQL stageSQL;
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;

    @Autowired
    public PortfolioActiveObjectsStagePersistence(ActiveObjectsUtilities utils, PortfolioPlanPersistence planPersistence, PortfolioEstimatePersistence estimatePersistence) {
        super(utils, IStage.class, AOStage.class);
        this.planPersistence = planPersistence;
        this.estimatePersistence = estimatePersistence;
        this.entityInfoSQL = new EntityInfoSQL(utils);
        this.stageSQL = new StageSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioStagePersistence.class;
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.estimatePersistence.clearEstimatesForTarget("stage", id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to clear estimates for stage " + id + " on deletion.", ex);
        }
        try {
            this.deleteAllStageAbilities(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to clear abilities for stage " + id + " on deletion.", ex);
        }
        return super.delete(id, inCascade);
    }

    @Override
    protected void transform(IStage source, AOStage target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setColor(source.getColor());
        target.setPercentage(source.getPercentage());
        if (source.getPlan() != null) {
            target.setPlan((IPlan)this.planPersistence.get(source.getPlan().getId()));
        }
    }

    @Override
    public List<IStage> listCustom(String planId) throws PersistenceException, SQLException {
        return this.stageSQL.getStages(planId);
    }

    @Override
    public void deleteAllStageAbilities(String stageId) throws SQLException {
        this.stageSQL.deleteAllStageAbilities(stageId);
    }

    @Override
    public EntityInfo getEntityInfo(String stageId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(stageId, AOStage.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOStage.class, "t").select().raw("*").from("t").where().col("t", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().col("t", "sortOrder");
        }
    }
}

