/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.upgrade.tasks;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AOStream;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.upgrade.BaseUpgradeTask;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class U_01200_ReleasesToStreamsUpgradeTask
extends BaseUpgradeTask {
    @Override
    protected int getDataModelVersion() {
        return 1200;
    }

    @Override
    protected void performUpgrade(ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) throws Exception {
        UpgradeSQL sql = new UpgradeSQL(this, utils, persistenceIndex);
        sql.perform();
    }

    @Override
    protected boolean migrateOnUpgrade() {
        return true;
    }

    private class UpgradeSQL
    extends BaseAOPersistenceSQL {
        private final BaseUpgradeTask task;
        private final ActiveObjectsUtilities utils;
        private final PersistenceIndex persistenceIndex;

        public UpgradeSQL(BaseUpgradeTask task, ActiveObjectsUtilities utils, PersistenceIndex persistenceIndex) {
            super(utils);
            this.task = task;
            this.utils = utils;
            this.persistenceIndex = persistenceIndex;
        }

        private Connection getConnection() throws SQLException {
            return this.task.getOrCreateConnection(this.utils.getAccessor());
        }

        public void perform() throws Exception {
            PortfolioPlanPersistence planPersistence = this.persistenceIndex.getBeanFromContext(PortfolioPlanPersistence.class);
            PortfolioStreamPersistence streamPersistence = this.persistenceIndex.getBeanFromContext(PortfolioStreamPersistence.class);
            List<String> plansToUpgrade = this.getPlanIdsWithoutStreams();
            for (String planId : plansToUpgrade) {
                IPlan plan = (IPlan)planPersistence.get(planId);
                IStream stream = planPersistence.createDefaultReleaseStream(plan);
                streamPersistence.onAfterCreate(stream);
                this.moveReleasesFromPlanToStream(planId, stream.getId());
            }
            this.setStreamModeIfUnset();
        }

        private void setStreamModeIfUnset() throws SQLException {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPlan.class, "p").update().tableNoAlias("p").set().colNoAlias("p", "inStreamMode").eq().bool(false).where().colNoAlias("p", "inStreamMode").isNull();
                }
            }, this.getConnection());
        }

        private void moveReleasesFromPlanToStream(final String planId, final String streamId) throws SQLException {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AORelease.class, "r").update().tableNoAlias("r").set().colNoAlias("r", "aoPlan").eq().nullValue().raw(",").colNoAlias("r", "aoStream").eq().numeric(streamId).raw(",").colNoAlias("r", "orderRangeId").eq().str("stream-" + streamId).where().colNoAlias("r", "aoPlan").eq().numeric(planId);
                }
            }, this.getConnection());
        }

        private List<String> getPlanIdsWithoutStreams() throws SQLException {
            return this.sql(new IQuery<List<String>>(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOPlan.class, "p").withTable(AOStream.class, "s").select().colId("p").from("p").where().raw("(").select().raw("COUNT(*)").from("s").where().col("s", "aoPlan").eq().colId("p").raw(")").eq().numeric(0);
                }

                @Override
                public List<String> handleResult(ResultSet result) throws Exception {
                    ArrayList plans = Lists.newArrayList();
                    while (result.next()) {
                        plans.add(BaseAOPersistenceSQL.getString(result, 1));
                    }
                    return plans;
                }
            }, this.getConnection());
        }
    }
}

