/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.handlers.sync.SyncConfigValidationException;
import com.radiantminds.roadmap.common.handlers.sync.SyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.ValidatedWorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncConfiguration;

public class ValidatedSyncConfiguration
implements SyncConfiguration<ValidatedWorkItemSyncConfiguration, ReleaseSyncConfiguration> {
    private final String planId;
    private final ReleaseSyncConfiguration releaseSyncConfiguration;
    private final Optional<ValidatedWorkItemSyncConfiguration> workItemSyncConfig;

    private ValidatedSyncConfiguration(String planId, ReleaseSyncConfiguration releaseSyncConfiguration, Optional<ValidatedWorkItemSyncConfiguration> workItemSyncConfig) {
        this.planId = planId;
        this.releaseSyncConfiguration = releaseSyncConfiguration;
        this.workItemSyncConfig = workItemSyncConfig;
    }

    public static ValidatedSyncConfiguration create(SyncConfiguration<?, ?> syncConfiguration) throws SyncConfigValidationException {
        if (syncConfiguration.getPlanId() == null) {
            throw new SyncConfigValidationException("No plan id supplied.");
        }
        return new ValidatedSyncConfiguration(syncConfiguration.getPlanId(), (ReleaseSyncConfiguration)syncConfiguration.getReleaseSyncConfiguration().orNull(), ValidatedWorkItemSyncConfiguration.tryCreate((WorkItemSyncConfiguration)syncConfiguration.getWorkItemSyncConfiguration().orNull()));
    }

    @Override
    public String getPlanId() {
        return this.planId;
    }

    @Override
    public Optional<ReleaseSyncConfiguration> getReleaseSyncConfiguration() {
        return Optional.fromNullable((Object)this.releaseSyncConfiguration);
    }

    @Override
    public Optional<ValidatedWorkItemSyncConfiguration> getWorkItemSyncConfiguration() {
        return this.workItemSyncConfig;
    }
}

