/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.exceptions;

import com.radiantminds.roadmap.common.rest.exceptions.RestStackTraceElement;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="exception")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestException {
    @XmlElement
    private String type;
    @XmlElement
    private String message;
    @XmlElement
    private List<RestStackTraceElement> stackTrace;
    @XmlElement
    private RestException cause;

    private RestException() {
    }

    static RestException from(Throwable template, List<Throwable> cycleDetection) {
        if (cycleDetection.contains(template)) {
            return null;
        }
        cycleDetection.add(template);
        RestException retVal = new RestException();
        retVal.type = template.getClass().getName();
        retVal.message = template.getMessage();
        retVal.stackTrace = RestStackTraceElement.from(template.getStackTrace());
        if (template.getCause() != null) {
            retVal.cause = RestException.from(template.getCause(), cycleDetection);
        }
        return retVal;
    }
}

